import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOraclepaasDatabaseServiceInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/d/database_service_instance#id DataOraclepaasDatabaseServiceInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/oraclepaas/d/database_service_instance#name DataOraclepaasDatabaseServiceInstance#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/oraclepaas/d/database_service_instance oraclepaas_database_service_instance}
*/
export declare class DataOraclepaasDatabaseServiceInstance extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "oraclepaas_database_service_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/oraclepaas/d/database_service_instance oraclepaas_database_service_instance} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOraclepaasDatabaseServiceInstanceConfig
    */
    constructor(scope: Construct, id: string, config: DataOraclepaasDatabaseServiceInstanceConfig);
    get apexUrl(): string;
    get availabilityDomain(): string;
    get backupDestination(): string;
    get bringYourOwnLicense(): cdktf.IResolvable;
    get characterSet(): string;
    get cloudStorageContainer(): string;
    get computeSiteName(): string;
    get description(): string;
    get edition(): string;
    get enterpriseManagerUrl(): string;
    get failoverDatabase(): cdktf.IResolvable;
    get glassfishUrl(): string;
    get highPerformanceStorage(): cdktf.IResolvable;
    get hybridDisasterRecoveryIp(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get identityDomain(): string;
    get ipNetwork(): string;
    get ipReservations(): string;
    get level(): string;
    get listenerPort(): number;
    get monitorUrl(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get nationalCharacterSet(): string;
    get pluggableDatabaseName(): string;
    get region(): string;
    get shape(): string;
    get uri(): string;
    get version(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
