# Upper Bound Theorem 2


```python
import ema as em
import matplotlib.pyplot as plt
import numpy as np
%config InlineBackend.figure_format = 'svg' # used to make plots look nicerbb
```


```python
mdl = em.Model(2,3)
n = mdl.dnodes
e = mdl.delems

mdl.node('1',  0.0, 0.0)
mdl.node('2',  6.0, 0.0)
mdl.node('3',  12.0, 0.0)
mdl.node('4', 0.0, 8.0)

mdl.beam('a', n['1'], n['2'])
mdl.beam('b', n['2'], n['3'])
mdl.truss('c', n['2'], n['4'])

mdl.fix(n['1'], ['x', 'y', 'rz'])
mdl.fix(n['3'], ['y'])
mdl.fix(n['4'], ['x','y', 'rz'])

mdl.numDOF()
```




    [[6, 7, 8], [1, 2, 3], [4, 9, 5], [10, 11, 12]]




```python
# Define plastic capacity
e['a'].Qp['+']['1'] = e['a'].Qp['-']['1'] = 500
e['a'].Qp['+']['2'] = e['a'].Qp['-']['2'] = 150
e['a'].Qp['+']['3'] = e['a'].Qp['-']['3'] = 150
e['c'].Qp['+']['1'] = e['c'].Qp['-']['1'] =  20
e['b'].Qp['+']['1'] = e['b'].Qp['-']['1'] = 500
e['b'].Qp['+']['2'] = e['b'].Qp['-']['2'] = 150
e['b'].Qp['+']['3'] = e['b'].Qp['-']['3'] = 150
```


```python
em.analysis.characterize(mdl)
```




    (0, 2)




```python
fig, ax = plt.subplots(1,1)
em.plot_structure(mdl, ax)
```


![svg](output_5_0.svg)



```python
A = em.A_matrix(mdl)
A.f
```




<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>$1$</th>
      <th>$2$</th>
      <th>$3$</th>
      <th>$4$</th>
      <th>$5$</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>$a_1$</th>
      <td>1.0</td>
      <td>0.000000</td>
      <td>0.0</td>
      <td>0.0</td>
      <td>0.0</td>
    </tr>
    <tr>
      <th>$a_2$</th>
      <td>0.0</td>
      <td>-0.166667</td>
      <td>0.0</td>
      <td>0.0</td>
      <td>0.0</td>
    </tr>
    <tr>
      <th>$a_3$</th>
      <td>0.0</td>
      <td>-0.166667</td>
      <td>1.0</td>
      <td>0.0</td>
      <td>0.0</td>
    </tr>
    <tr>
      <th>$b_1$</th>
      <td>-1.0</td>
      <td>-0.000000</td>
      <td>0.0</td>
      <td>1.0</td>
      <td>0.0</td>
    </tr>
    <tr>
      <th>$b_2$</th>
      <td>-0.0</td>
      <td>0.166667</td>
      <td>1.0</td>
      <td>0.0</td>
      <td>0.0</td>
    </tr>
    <tr>
      <th>$b_3$</th>
      <td>-0.0</td>
      <td>0.166667</td>
      <td>0.0</td>
      <td>0.0</td>
      <td>1.0</td>
    </tr>
    <tr>
      <th>$c_1$</th>
      <td>0.6</td>
      <td>-0.800000</td>
      <td>0.0</td>
      <td>0.0</td>
      <td>0.0</td>
    </tr>
  </tbody>
</table>



### Vertical mechanism


```python
n['2'].p['y'] = -50
n['3'].p['x'] =  0.
lambdac, Q = em.analysis.PlasticAnalysis_wLBT(mdl)
Q
```




<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>$Q_{{}}$</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>$a_1$</th>
      <td>-12.0</td>
    </tr>
    <tr>
      <th>$a_2$</th>
      <td>150.0</td>
    </tr>
    <tr>
      <th>$a_3$</th>
      <td>150.0</td>
    </tr>
    <tr>
      <th>$b_1$</th>
      <td>0.0</td>
    </tr>
    <tr>
      <th>$b_2$</th>
      <td>-150.0</td>
    </tr>
    <tr>
      <th>$b_3$</th>
      <td>0.0</td>
    </tr>
    <tr>
      <th>$c_1$</th>
      <td>20.0</td>
    </tr>
  </tbody>
</table>




```python
lambdac
```




    1.82




```python
B = em.B_matrix(mdl)
P = em.P_vector(B)
P.f
```




<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>$P_{{fffff}}$</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>$1$</th>
      <td>0.0</td>
    </tr>
    <tr>
      <th>$2$</th>
      <td>-50.0</td>
    </tr>
    <tr>
      <th>$3$</th>
      <td>0.0</td>
    </tr>
    <tr>
      <th>$4$</th>
      <td>0.0</td>
    </tr>
    <tr>
      <th>$5$</th>
      <td>0.0</td>
    </tr>
  </tbody>
</table>




```python
A.f@[0, 1,0, 0, 0]
```




<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>$Vector_{{fffff}}$</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>$a_1$</th>
      <td>0.000000</td>
    </tr>
    <tr>
      <th>$a_2$</th>
      <td>-0.166667</td>
    </tr>
    <tr>
      <th>$a_3$</th>
      <td>-0.166667</td>
    </tr>
    <tr>
      <th>$b_1$</th>
      <td>0.000000</td>
    </tr>
    <tr>
      <th>$b_2$</th>
      <td>0.166667</td>
    </tr>
    <tr>
      <th>$b_3$</th>
      <td>0.166667</td>
    </tr>
    <tr>
      <th>$c_1$</th>
      <td>-0.800000</td>
    </tr>
  </tbody>
</table>




```python
[0, 1,0, 0, 0]@P.f
```

    C:\Users\claud\Anaconda3\lib\site-packages\IPython\core\formatters.py:371: FormatterWarning: text/html formatter returned invalid type <class 'ema.matvecs.P_vector'> (expected <class 'str'>) for object: P_vector(-50.)
      FormatterWarning
    




    P_vector(-50.)




```python
Qpl = em.Qpl_vector(mdl)[:,0]
Qpl
```




<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>0</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>0</th>
      <td>500</td>
    </tr>
    <tr>
      <th>1</th>
      <td>150</td>
    </tr>
    <tr>
      <th>2</th>
      <td>150</td>
    </tr>
    <tr>
      <th>3</th>
      <td>500</td>
    </tr>
    <tr>
      <th>4</th>
      <td>150</td>
    </tr>
    <tr>
      <th>5</th>
      <td>150</td>
    </tr>
    <tr>
      <th>6</th>
      <td>20</td>
    </tr>
  </tbody>
</table>




```python
np.abs(A.f@[0, 1,0, 0, 0])@np.abs(Q)
```

    C:\Users\claud\Anaconda3\lib\site-packages\IPython\core\formatters.py:371: FormatterWarning: text/html formatter returned invalid type <class 'ema.utilities.Structural_Vector'> (expected <class 'str'>) for object: Structural_Vector(91.)
      FormatterWarning
    




    Structural_Vector(91.)




```python

```
