```python
import ema as em
import numpy as np
import sympy as sp
import pandas as pd
import scipy.linalg
import matplotlib.pyplot as plt
%config InlineBackend.figure_format = 'svg'

```


```python
mdl = em.rModel(2,3)
e = mdl.delems
n = mdl.dnodes
h = 5
w = 8
Qp_c = 150
Qp_g = 120
mdl.node('1', 0.0,  0.0 )
mdl.node('2', 0.0,   h  ) 
mdl.node('3', w/2,   h  )
mdl.node('4',  w ,   h  )
mdl.node('5',  w ,  0.0 ) 

mdl.beam('a', n['1'],  n['2'] , Qpl=[1e6, Qp_c, Qp_c])
mdl.beam('b', n['2'],  n['3'] , Qpl=[1e6, Qp_g, Qp_g])
mdl.beam('c', n['3'],  n['4'] , Qpl=[1e6, Qp_g, Qp_g])
mdl.beam('d', n['4'],  n['5'] , Qpl=[1e6, Qp_c, Qp_c])

mdl.boun(n['1'], [1, 1, 1])
mdl.boun(n['5'], [1, 1, 1])

mdl.DOF = mdl.numdofs()
mdl.nf
```




    5




```python
fig, ax = plt.subplots()
em.plot_structure(mdl, ax, labeled=True)
```


![svg](output_2_0.svg)



```python
n['2'].p['x'] = 30
n['3'].p['y'] =-50
c, A_ub, b_ub, A_eq, b_eq, bounds, Q_row_data = em.analysis.setupPlasticAnalysis_wLBT(mdl)
```


```python
Pref = np.array([30, 0, -50, 0, 0])
```


```python
e2e = em.Event2Event(mdl, Pref)
e2e.run();
```


```python
Qc = e2e.Q[-1].c
Vc = e2e.V[-1].c
```


```python
e2e.lamdah
```




    array([0.])




```python
Vdot = np.array([0.2, 0, 0, 0.4, 0, -0.4, 0.0, 0.2])
Vdot
```




    array([ 0.2,  0. ,  0. ,  0.4,  0. , -0.4,  0. ,  0.2])




```python
em.Fs_matrix(mdl) .c @ Qc
```




<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>$V_{{}}$</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>$a_2$</th>
      <td>321.428571</td>
    </tr>
    <tr>
      <th>$a_3$</th>
      <td>-267.857143</td>
    </tr>
    <tr>
      <th>$b_2$</th>
      <td>34.285714</td>
    </tr>
    <tr>
      <th>$b_3$</th>
      <td>102.857143</td>
    </tr>
    <tr>
      <th>$c_2$</th>
      <td>-80.000000</td>
    </tr>
    <tr>
      <th>$c_3$</th>
      <td>-80.000000</td>
    </tr>
    <tr>
      <th>$d_2$</th>
      <td>75.000000</td>
    </tr>
    <tr>
      <th>$d_3$</th>
      <td>150.000000</td>
    </tr>
  </tbody>
</table>




```python
mdl.idx_c
```




    array([ 1,  2,  4,  5,  7,  8, 10, 11], dtype=int64)




```python
pd.DataFrame(e2e.Amp)
```




<div>
<style scoped>
    .dataframe tbody tr th:only-of-type {
        vertical-align: middle;
    }

    .dataframe tbody tr th {
        vertical-align: top;
    }

    .dataframe thead th {
        text-align: right;
    }
</style>
<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>0</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>0</th>
      <td>0.0</td>
    </tr>
    <tr>
      <th>1</th>
      <td>0.0</td>
    </tr>
    <tr>
      <th>2</th>
      <td>0.0</td>
    </tr>
    <tr>
      <th>3</th>
      <td>0.0</td>
    </tr>
    <tr>
      <th>4</th>
      <td>0.0</td>
    </tr>
  </tbody>
</table>
</div>




```python
e2e.init()
e2e.next()
scipy.linalg.null_space(e2e.Af[e2e.ind_e, :].T)
```




    array([[-4.95195536e-01, -5.81476323e-01],
           [ 5.48433093e-01, -1.80428589e-01],
           [-5.48433093e-01,  1.80428589e-01],
           [ 2.74216546e-01, -9.02142947e-02],
           [-2.74216546e-01,  9.02142947e-02],
           [ 1.11022302e-16, -2.77555756e-17],
           [-5.32375568e-02,  7.61904913e-01]])


