# -*- coding: utf-8 -*-
# hmath
# v.3.3.5
# by caleb7023
#
#                                        ...(+uwXuuZuuZuuZZuZXA&J-..
#                                   ..uuuuuuZuuZuZuuZuuZZZuZZZZZZZZZZZG-.
#                                .(uZuuZuuZuZuZuZuZuZZZZZuZZZuZZZZZZZZZZZZn,
#                               .uuZuZuuZZuZuZuZuuZZuZZuZZZZZZZZZZZZZZZZZZZZk,
#                              (Zuuuuu=`   _7uuZuZZuZZZZZZuZZZZZZZZZZZZZZZZZZy+
#                              uuZuZu:       (uZZZuZZZuZZZZZZZZZZZZZZZZZZyZZyZZ.
#                              uuuZuu.       .ZZuZZZZZZZZZZZZZZZZZZZZZZZZZyZZZy}
#                              uuZZuZn       JZZZZZuZZZZZZZZZZZZZZZZZZyZyZZyZyZ}
#                              uZuZuuuu&...JZZZuZZZZZZZZZZZZZZZZZZZZZZZyZZZyZZy}
#                           ...mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmQQQQQQQQQQo......
#                      ..gMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM%
#                    .MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM#
#                  .MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM]
#                .(MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM#_~~~~~~~~~_..
#            .+ZQMMMMMMMMMMHWUUWWWWWWWMMM#WWWWWWWWWWWWWWWWWWWMMM#WWWWWWWWWWWWWW%~~~~.~.~.~.~~~~~~_.
#          .uuZdMMMMMMUuuZuZuZZZZZZZZdMMM#ZZZZZZZZZZZZZZZZZZdMMM#ZyZyZyyyyyyyyy}   ~.~~.~~.~~.~~~~~_
#        .uZuXMMMMMSZZuuZuZZZZZZZZZZZMMMM#ZZZZZZZZZZZZZZZZZyMMMMWyZyZyZyZyyZyyy}   ~~.~~.~~~.~~~~~~~~.
#       .ZuuXMMMMuZuuZuZZZZZuZZZZZZZXMMMMHZZZZZZZZZZZZyZyyZXMMM#yyZyyZyyyZyyyZy}   .~~.~~.~~~~.~~.~~~~-
#      .uZuZMMMSuuZuuZZZZuZZZZuZZZZZdMMMMWZZZZZZZZZyZZZyZZyMMMMHZyyZyyyZyyyyyyZ}   ~~.~~~~~~~~~.~~~.~~~.
#     .uuZuZuuuZZuZZZuZZuZZZZZZZZZZZMMMMNZZZZZZZyZyZZyZZyZyMMMMyyZyyZyyyyyZyyyy:   ~~~.~~.~.~~~~~~~~~~~_
#     JZuuZZuZuZuuZZuZZZZZZuZZZZZZZdMMMM#ZZZZyZZZyZZyZyZyZXMMM#ZyyZyyZyyZyyyZy0    ~.~~~~~~~.~.~~.~~~~~~.
#    .uuZuuZZuZuZZZZuZZuZZZZZZZZZZZMMMMMHZZyZZyZZZyZZyZyZydMMMHZyyyyyyyyyyyyyX'   _~~~~.~~.~~~~~~~~~~~~~_
#    ,ZuZZuZuZuZZZuZZZZZZZZZZZZZZZXMMMMMZZZyZZZyyZyZyZyZyZMMMMyyZyZyyyZyyZyyf!    ~~~.~~~.~~~~~.~~~~~~~~~
#    JuZuuZuZZZuZZZZZZZZZZZZZZZZZZMMMMM#ZyZZZyZZZyZyZyZyyXMMM#yyyyyyyZyyyyV^     ~~~~~~~~~~~.~~~~~~~~~~~~
#    dZuuZuZZuZZZuZZZZZZZZZZZZZZZdMMMMMWZZyZyZyZyZyZyyZyydMMM#yyyyyZyXVY^`     .~~.~~.~.~~~~~~~~~~~~~~~~~
#    uZuZZZZuZZZZZZZZZZZZZZZZZZZXMMMMMF``                dMMM`               .~~~~~~.~~~~.~~~~~~~~~~~~~~~
#    uuZZuZZZZZuZZZZZZZZZZZZZZZZMMMMMM`                  MMM@           .._~~~~~~.~~~~~~~~~~~~~~~~~~~~~~~
#    wZZZZZZZZZZZZZZZZZZZZZZZZfdMMMMMD.....~.....~..~..~.~~~.~~.~~.~.~~~~~~~~~~.~~~~~~~~~~~~~~~~~~~~~~~~~
#    zZZZuZuZZZZZZZZZZZZZZZZZf.MMM#=....~.~..~.~.~~.~~.~..~.~.~~~.~~~.~~~.~.~~.~~~.~~.~~~~~~~~~~~~~~~~~~~
#    (ZZZZZZZZZZZZZZZZZZZZyZf.MMMt..~.~..~..~.~.~..~.~~~~~.~~.~~.~~~~~.~~~~~.~~~~~~~~~~~~~~~~~~~~~~~~~~:~
#    .ZZZZZZZZZZZZZZZZZZZZZZjMMM3.~..~..~..~.~..~.~..~..~~.~~~.~~~.~~~~~.~~~~~~~.~~~~~~~~~~~~~~~~~~~~:~~_
#     XZZZZZZZZZZZZZZZyZyZyqMMMF.~..~..~..~..~.~.~~~~.~~.~~.~.~~.~~.~.~~~.~~~.~~~~~~~~~~~~~~~~~~~~~~:~~~`
#     -ZZZZZZZZZZZZyZZZyZydMMMM!..~..~..~.~.~.~~.~.~~.~~.~~.~~~~~~~~~~.~~~~.~~~~~~~~~~~~~~~~~~~~~:~~~:~_
#      jZZZZZZZZZyZZZyZZXMMMMMN~..~..~.~.~.~.~.~~.~.~~.~~.~~~~.~~.~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~:~~~_
#       4ZZZZZZZZZZyZZZQMMMMMMM~.~.~..~.~.~.~~.~.~~.~~.~~~~.~~~~~~.~.~~.~~~~~~~~~~~~~~~~~~~~~~:~:~~:~_
#        4ZZZZyZZyZZyXNMMMMMMMM~..~.~.~.~.~~.~~.~~.~~.~~.~~~~.~~.~~~~~~~~~.~~~~~~~~~~~~~~~~~~:~~~:~~_
#         ?XZZZZyZZyqMMMMMMMMM$.~..~.~.~.~.~~.~~.~~.~~~~~.~~~~.~~~~~~.~~~~~~~~~~~~~~~~~~~~:~~~~:~~_`
#           ?UyZZyqMMMMMMMMMM% .~~..~.~.~~.~.~.~~.~~.~~~~~.~~~~~~.~~~~~~~~~~~~~~~~~~~~~~~:~~:~~_`
#              ?qMMMMMMMMMMM^  ~..~~.~~.~~~.~~~.~~~~~~.```u&&&&&&gggggggg++J_````````````````
#                ?WMMMMMMMM'   ~.~.~.~~~..~~.~~~~.~~~~~    TMMMMMMMMMMMMMB=
#                   (TMMMB`    ~~.~~..~~.~~.~~.~~~.~.~~~~.~~._?<<<<<<<<~~~~~~~~_
#                       7      .~.~~~.~~~~.~~.~~~~~~~~.~~~~~~~~~~~~~~~~~~~~~~~~_
#                              ~~.~~.~~.~~~~~~~.~.~~~.~~~~~~~~~~~~~~~~~~~~~~~~~_
#                              ~~.~~.~~.~.~~.~~~~~.~~~~~~~.~~~~~~~_````_~~~:~~:_
#                              ~~.~~~~.~~~.~~~.~~~~~~~.~~~~~~~~~~`       ~~~:~~_
#                              ~.~~.~~~~~~~~~.~~.~~.~~~~~~~~~~~~_        _~~~~~_
#                              _~~~.~.~~.~~.~~~~~~~~~~~~~~~~~~~~_        _:~:~~_
#                               _~~~~~~.~~~~~~~~~.~~~~~~~~~~~~~~~_.    .~~~:~~:
#                                `~~.~~~~.~~.~~.~~~~~~~~~~~~~~~~~~~~~~~:~~~~~_`
#                                     `_~~~~~.~~~~~~~~~~~~~~~~~~~~~~~:~~:~~:~:_`
#                                     ``.~~~~~~~~~~~~~~~~~~~~~~:~~~:~~:__`
#                                           ```___~~~~~~~~~~~~____``
#

"""
# [hmath](https://caleb7023.hmath.pro)

![hmath](https://caleb7023.hmath.pro)

hmath was developed to use advanced math functions in python.
You can use complex numbers for most functions.

# Version
[v.3.3.5](https://caleb7023.hmath.pro/version/v-3-3-5)

hmath is investigating whether the calculation of the function is correct and whether the calculation is efficient. 
Please help us provide information on efficient calculation methods and whether the calculations are correct.
[Click on this to answer.](https://caleb7023.hmath.pro/Feedback)


[Feedback on hmath modules](https://caleb7023.hmath.pro/Feedback)
"""
print("The function is being processed.")
__corresponding_dictionary = {
    "B"                     : {},
    "ln"                    : {},
    "rad"                   : {},
    "exp"                   : {},
    "sin"                   : {},
    "cos"                   : {},
    "tan"                   : {},
    "csc"                   : {},
    "sec"                   : {},
    "cot"                   : {},
    "asin"                  : {},
    "acos"                  : {},
    "atan"                  : {},
    "acsc"                  : {},
    "asec"                  : {},
    "acot"                  : {},
    "sinh"                  : {},
    "cosh"                  : {},
    "tanh"                  : {},
    "csch"                  : {},
    "sech"                  : {},
    "coth"                  : {},
    "asinh"                 : {},
    "acosh"                 : {},
    "atanh"                 : {},
    "acsch"                 : {},
    "asech"                 : {},
    "acoth"                 : {},
    "Gamma"                 : {},
    "polyGamma"             : {},
    "cube_root"             : {},
    "factorial"             : {},
    "square_root"           : {},
    "primality_test"        : {},
    "prime_factorization"   : {},
    "reduction_of_fraction" : {},
}

def __memo(func):
    def memo(*args):
        global __corresponding_dictionary
        if func.__name__ != "dlist":
            if args in __corresponding_dictionary[func.__name__]:
                ans = __corresponding_dictionary[func.__name__][args]
            else:
                new_func = func
                if len(args) == 1:
                    ans = new_func(args[0])
                if len(args) == 2:
                    ans = new_func(args[0], args[1])
                if len(args) == 3:
                    ans = new_func(args[0], args[1], args[2])
                __corresponding_dictionary[func.__name__][args] = ans
        else:
            new_func = func
            if len(args) == 1:
                ans = new_func(args[0])
            if len(args) == 2:
                ans = new_func(args[0], args[1])
            if len(args) == 3:
                ans = new_func(args[0], args[1], args[2])
        return ans
    return memo

def __list(func):
    def dlist(*args):
        try:
            if len(args) == 1:
                ans = [func(value) for value in args[0]]
            if len(args) == 2:
                args1 = list(args[0])
                args2 =      args[1]
                try:
                    args2 = list(args2)
                    ans = []
                    for process in len(args1):
                        value1 = args1[process]
                        value2 = args2[process]
                        ans += [func(value1, value2)]
                except:
                    ans = []
                    for process in len(args1):
                        value1 = args1[process]
                        ans += [func(value1)]
            if type(args[0]) == array:
                return array(ans)
            return ans
        except:
            if len(args) == 1:
                return func(args[0])
            if len(args) == 2:
                return func(args[0], args[1])
            if len(args) == 3:
                return func(args[0], args[1], args[2])
    return dlist

def __pow(func):
    def pow(args1, args2 = 0):
        ans = args1
        if type(args2) == str:
            k = 0.01
            for h in range(len(args2)):
                if args2[h] == "d":
                    ans = (func(ans + k) - func(ans)) / k
                else:
                    raise Exception('The value of the argument must be a string that contains only "d" or a natural number.')
            return ans
        elif args2 < 0 or not args2 % 1 == 0:
            raise Exception('The value of the argument must be a string that contains only "d" or a natural number.')
        else:
            for k in range(args2 + 1):
                ans = func(ans)
        return ans
    return pow

class array:
    """
    "array" is used to represent a array.

    example:
    >>> hmath.array([3, 2])
    array[3, 2]
    >>> hmath.array([3.1, -2.5, 9])
    array[ 3.1, -2.5,    9]
    >>> hmath.array([[3 + 5j, 3], [hmath.fraction(4, 3), -32]])
    array[[ (3+5j),      3],
          [(4 / 3),    -32]]
    """
    def __init__(self, array_list):
        if array.__size_check(array_list):
            self.array_list = array_list
        else:
            raise Exception("All lists in the list should be the same length.\nThis also applies to lists in lists.")
    
    def __to_array(data):
        if type(data) == list:
            return array(data)
        return data
    
    def __size_check(self):
        if type(self[0]) != list:
            return True
        self_size = len(self[0])
        list_in_self = 0
        for process in self:
            if type(process) == list:
                list_in_self = 1
                if self_size != len(process):
                    return False
                if type(process[0]) == list:
                    if not(array.__size_check(process)):
                        return False
            if (type(process) != list) == list_in_self:
                return False
        return True
    
    def __max_len(self):
        max_len = 0
        for value in self:
            if type(value) == array:
                value_max_len = array.__max_len(value)
                if  max_len < value_max_len:
                    max_len = value_max_len
            else:
                if  max_len < len(str(value)):
                    max_len = len(str(value))
        return max_len
    
    def __trim(self, deep, self_max_len):
        self_trim = ""
        if  deep == 1:
            self_trim = "array["
        roop_time = 0
        for value in self:
            if  type(value) == array:
                if roop_time == 1:
                    self_trim += ",\n     %s" %(deep * " ")
                self_trim += "[%s" %(array.__trim(value, deep + 1, self_max_len))
            else:
                if  roop_time == 1:
                    self_trim += ", "
                self_trim += "%s%s" %((self_max_len - len(str(value))) * " ", value)
            roop_time = 1
        return "%s]" %(self_trim)
    
    def __repr__(self):
        return array.__trim(self, 1, array.__max_len(self))
    #in
    def __contains__(self, other):
        return other in self.array_list
    
    def __getitem__(self, other):
        return array.__to_array(self.array_list[other])
    
    def __iter__(self):
        self.roop_time = -1
        return self
    
    def __next__(self):
        self.roop_time += 1
        if self.roop_time == len(self): raise StopIteration
        return array.__to_array(self.array_list[self.roop_time])
    
    def __list__(self):
        return self.array_list
    
    def __str__(self):
        return "array%s" %(self.array_list)
    
    def __bool__(self):
        return array([bool(value1) for value1 in self])
    
    def __not__(self):
        return array([not(value1) for value1 in self])
    
    def __len__(self):
        return len(self.array_list)
    
    def __abs__(self):
        return array([abs(value1) for value1 in self])
    
    def __float__(self):
        return array([float(value1) for value1 in self])
    
    def __round__(self, other):
        return array([round(value1, other) for value1 in self.array_list])
    #+
    def __add__ (self, other):
        if type(self) == type(other) == array:
            return array([value1 + value2 for value1, value2 in zip(self, other)])
        return array([value1 + other for value1 in self])
    def __radd__(self, other):
        return array([value1 + other for value1 in self])
    #-
    def __sub__ (self, other):
        if type(other) == array:
            return array([value1 - value2 for value1, value2 in zip(self, other)])
        return array([value1 - other for value1 in self])
    def __rsub__(self, other):
        return array([value1 - other for value1 in self])
    def __neg__(self):
        return 0 - self
    #*
    def __mul__ (self, other):
        if type(other) == array:
            return array([value1 * value2 for value1, value2 in zip(self, other)])
        return array([value1 * other for value1 in self])
    def __rmul__(self, other):
        return array([value1 * other for value1 in self])
    #/
    def __truediv__ (self, other):
        if type(other) == array:
            return array([value1 / value2 for value1, value2 in zip(self, other)])
        return array([value1 / other for value1 in self])
    def __rtruediv__(self, other):
        return array([value1 / other for value1 in self])
    #//
    def __floordiv__ (self, other):
        if type(other) == array:
            return array([value1 // value2 for value1, value2 in zip(self, other)])
        return array([value1 // other for value1 in self])
    def __rflooediv__(self, other):
        return array([value1 // other for value1 in self])
    #**
    def __pow__ (self, other):
        if type(other) == array:
            return array([value1 ** value2 for value1, value2 in zip(self, other)])
        return array([value1 ** other for value1 in self])
    def __rpow__(self, other):
        return array([value1 ** other for value1 in self])
    #%
    def __divmod__ (self, other):
        if type(other) == array:
            return array([value1 % value2 for value1, value2 in zip(self, other)])
        return array([value1 % other for value1 in self])
    def __rdivmod__(self, other):
        return array([value1 % other for value1 in self])
    #==
    def __eq__ (self, other):
        if type(other) == array:
            return array([value1 == value2 for value1, value2 in zip(self, other)])
        return array([value1 == other for value1 in self])
    def __req__(self, other):
        return array([value1 == other for value1 in self])
    #!=
    def __ne__ (self, other):
        return not self == other
    def __rne__(self, other):
        return not self == other
    #<
    def __lt__ (self, other):
        if type(other) == array:
            return array([value1 < value2 for value1, value2 in zip(self, other)])
        return array([value1 < other for value1 in self])
    def __rlt__(self, other):
        return array([value1 < other for value1 in self])
    #>
    def __gt__ (self, other):
        if type(other) == array:
            return array([value1 > value2 for value1, value2 in zip(self, other)])
        return array([value1 > other for value1 in self])
    def __rgt__(self, other):
        return array([value1 > other for value1 in self])
    #<=
    def __le__ (self, other):
        if type(other) == array:
            return array([value1 <= value2 for value1, value2 in zip(self, other)])
        return array([value1 <= other for value1 in self])
    def __rle__(self, other):
        return array([value1 <= other for value1 in self])
    #>=
    def __ge__ (self, other):
        if type(other) == fraction:
            return array([value1 >= value2 for value1, value2 in zip(self, other)])
        return array([value1 >= other for value1 in self])
    def __rge__(self, other):
        return array([value1 >= other for value1 in self])

class fraction:
    """
    "fraction" is used to represent a fraction.

    example:
    >>> hmath.fraction(3, 4)
    (3 / 4)
    >>> hmath.fraction(-7, 8)
    (-7 / 8)
    >>> hmath.fraction(3 + 5j, 3)
    ((3+5j) / 3)
    """
    def __init__(self, mole, deno):
        self.mole = mole
        self.deno = deno
    
    def __repr__(self):
        return str(self)
    
    def __bool__(self):
        return self.mole != 0
    
    def __str__(self):
        self = reduction_of_fraction(self)
        if not(type(self) == fraction):
            return "(%s / 1)" %(str(self))
        elif not(type(self.mole) == complex or type(self.deno) == complex):
            if self.mole < 0 or self.deno < 0:
                if self.mole < 0 and self.deno < 0:
                    return "(%s / %s)" %(abs(self.mole), abs(self.deno))
                return "-(%s / %s)" %(abs(self.mole), abs(self.deno))
        return "(%s / %s)" %(self.mole, self.deno)
    
    def __abs__(self):
        return fraction(abs(self.mole), abs(self.deno))
    
    def __float__(self):
        return div(self.mole , self.deno)
    
    def __round__(self, other):
        return fraction((self.deno * (1 / 10 ** (other - 1)) // self.mole) * self.deno, self.deno)
    #+
    def __add__(self, other):
        if not type(other) == fraction:
            return fraction(self.mole + other * self.deno, self.deno)
        return fraction(self.mole * other.deno + other.mole * self.deno, self.deno * other.deno)
    def __radd__(self, other):
        return fraction(self.mole + other * self.deno, self.deno)
    #-
    def __sub__(self, other):
        if not type(other) == fraction:
            return fraction(self.mole - other * self.deno, self.deno)
        return fraction(self.mole * other.deno - other.mole * self.deno, self.deno * other.deno)
    def __rsub__(self, other):
        return fraction(self.mole - other * self.deno, self.deno)
    #*
    def __mul__(self, other):
        if not type(other) == fraction:
            return fraction(self.mole * other, self.deno)
        return fraction(self.mole * other.mole, self.deno * other.deno)
    def __rmul__(self, other):
        return fraction(self.mole * other, self.deno)
    #/
    def __truediv__ (self, other):
        if not type(other) == fraction:
            return fraction(self.mole, self.deno * other)
        return fraction(self.mole * other.deno, self.deno * other.mole)
    def __rtruediv__(self, other):
        return fraction(self.deno * other, self.mole)
    
    def __floordiv__ (self, other):
        value_1 = self / other
        return value_1.mole // value_1.deno
    def __rflooediv__(self, other):
        value_1 = self / other
        return value_1.mole // value_1.deno
    #**
    def __pow__ (self, other):
        if not type(other) == fraction:
            return fraction(self.mole ** other, self.deno ** other)
        return fraction(self.mole ** (other.mole / other.deno), self.deno ** (other.mole / other.deno))
    def __rpow__(self, other):
        return other ** (self.mole / self.deno)
    
    def __divmod__ (self, other):
        value_1 = self // other
        return (value_1, self - other * value_1)
    def __rdivmod__(self, other):
        value_1 = self // other
        return (value_1, self - other * value_1)
    #==
    def __eq__ (self, other):
        if not type(other) == fraction:
            ans = other * self.deno
            return ans == self.mole
        return self.mole == other.mole and self.deno == other.deno
    def __req__(self, other):
        ans = other * self.deno
        return ans == self.mole
    #!=
    def __ne__ (self, other):
        return not self == other
    def __rne__(self, other):
        return not self == other
    #<
    def __lt__ (self, other):
        if not type(other) == fraction:
            return self.mole < self.deno * other
        return self.mole * other.deno < self.deno * other.mole
    def __rlt__(self, other):
        return self.mole < self.deno * other
    #>
    def __gt__ (self, other):
        if not type(other) == fraction:
            return self.mole > self.deno * other
        return self.mole * other.deno > self.deno * other.mole
    def __rgt__(self, other):
        return self.mole > self.deno * other
    #<=
    def __le__ (self, other):
        return self < other or self == other
    def __rle__(self, other):
        return self < other or self == other
    #>=
    def __ge__ (self, other):
        return self > other or self == other
    def __rge__(self, other):
        return self > other or self == other

@__memo
def Sigma(_roop_time, _first_value, _formula):
    ans = 0
    for n in range(_first_value, _roop_time):
        ans += eval(_formula)
    return ans

@__memo
def Pi(_roop_time, _first_value, _formula):
    ans = 0
    for n in range(_first_value, _roop_time):
        ans *= eval(_formula)
    return ans

@__list
@__memo
def reduction_of_fraction(_fr):
    """
    "reduction_of_fraction(x)" reduces the fraction x.
    """
    process = 1
    if type(_fr.mole) != complex and type(_fr.deno) != complex:
        if _fr.mole < 0 and _fr.deno < 0:
            _fr = reduction_of_fraction(abs(_fr))
            return _fr
        elif _fr.mole < 0 or _fr.deno < 0:
            _fr = reduction_of_fraction(-_fr)
            return _fr
        else:
            while True:
                process += 1
                test = primality_test(process)
                if test:
                    if _fr.mole / process % 1 == 0 and _fr.deno / process % 1 == 0:
                        _fr     = fraction(_fr.mole / process, _fr.deno / process)
                        process = 1
                elif min(abs(_fr.mole) , abs(_fr.deno)) < process:
                    break
            if _fr.deno == 1:
                _fr = _fr.mole
            elif _fr.deno == _fr.mole:
                _fr = 1
            return _fr
    return _fr

@__list
def complex_test(_x):
    """
    "complex_test(x)" returns whether x is a complex number.
    """
    try:
        a = _x.imag
        if a == 0:
            return False
        else:
            return True
    except:
        return True

@__list
@__memo
def primality_test(_n):
    """
    "primality_test(x)" returns whether x is a prime number.
    """
    root_n = _n ** 0.5
    divisible = True
    for test in range(int(root_n) - 1):
        if  int(_n / (test + 2)) == _n / (test + 2):
            divisible = False
            break
    return divisible

@__list
@__memo
def prime_factorization(_n):
    """
    "prime_factorization(x)" returns the result of factoring x into prime factors.
    """
    if primality_test(_n):
        return _n
    decomposition_result = []
    prime_factorization2_ans_1 = _n
    prime_factorization2_ans_2 = 1
    while not(prime_factorization2_ans_1 == 1):
        prime_factorization2_ans_2 = prime_factorization2_ans_1
        for k in range(2 , int(prime_factorization2_ans_1 ** 0.5) + 1):
            if prime_factorization2_ans_1 / k == prime_factorization2_ans_1 // k / 1:
                if primality_test(k):
                    prime_factorization2_ans_2 = k
                    break
        prime_factorization2_ans_1 = prime_factorization2_ans_1 / prime_factorization2_ans_2
        if not(prime_factorization2_ans_2 == 1):
            decomposition_result += [int(prime_factorization2_ans_2)]
    return decomposition_result

@__list
@__memo
def B(_n):
    n = _n / 2

@__list
@__memo
def rad(_n):
    factorization = prime_factorization(_n)
    existing_value = []
    for k in factorization:
        if k not in existing_value:
            existing_value += [k]
    ans = 1
    return (ans * i for i in existing_value)

@__list
def div(_x , _y):
    if _y == 0:
        if   0 < _x:
            return  inf()
        elif _x < 0:
            return -inf()
        else:
            return  0
    elif _y == inf():
        return 0
    else:
        return _x / _y

@__list
def imag_part(_x):
    try:
        return _x.imag
    except:
        return 0

@__list
def real_part(_x):
    try:
        return _x.real
    except:
        return 0

@__list
def P(_n, _k):
    return factorial(_n) / factorial(_k)

@__list
def C(_n, _k):
    return P(_n, _k) / factorial(_k)

def inf():
    """
    "inf()" returns infinity.
    """
    return float("inf")

def pi():
    """
    "pi()" returns the constant π.
    The value is approximately 3.1415926535897932384626433832795.
    """
    return 3.1415926535897932384626433832795

def e():
    """
    "e()" returns the constant e.
    The value is approximately 2.7182818284590452353602874713527.
    """
    return 2.7182818284590452353602874713527

def phi():
    """
    "phi()" returns the constant φ.
    The value is approximately 1.6180339887498948482045868343656.
    """
    return 1.6180339887498948482045868343656

def gamma():
    """
    "gamma()" returns the constant γ.
    The value is approximately 0.5772156649015328606065120900824.
    """
    return 0.5772156649015328606065120900824

def tau():
    """
    "tau()" returns the constant τ.
    The value is approximately 6.283185307179586476925286766559.
    """
    return 6.283185307179586476925286766559

@__list
@__memo
def exp(_x):
    """
    "exp(x)" returns the value of e power x.
    """
    return e() ** _x

@__list
@__memo
def ln(_x):
    value_2 = 0
    for n in range(1 , 2000):
        value_3 = 2 ** (-n)
        value_2 += div(value_3 * (_x ** value_3), 1 + (_x ** value_3))
    return div(1 , div(_x , _x - 1) - value_2)

@__list
@__memo
def log(_x , _y):
    return div(ln(_y) , ln(_x))

@__list
@__memo
def square_root(_x):
    return _x ** 0.5

@__list
@__memo
def cube_root(_x):
    return _x ** 0.3333333333333333333333333333333333333333

@__list
@__memo
def radical(_x , _y):
    return _y ** (1 / _x)

@__list
@__pow
@__memo
def Gamma(_x, _n = 0):
    if not complex_test(_x):
        if _x < 0:
            value_1 = 1
            for n in range(1 , 100000):
                value_1 *= div(((1 + (1 / n)) ** _x) , (1 + (_x / n)))
            return 1 / _x * value_1
    return (2.5066282746310002 * exp(0-_x) * square_root(div(1, _x)) * (_x * square_root(div(1, 810 * (_x ** 6))  + _x * sinh(div(1, _x)))) ** _x)

@__list
@__memo
def factorial(_x):
    """
    "factorial(x)" returns the value of x!
    """
    if not complex_test(_x):
        if _x % 1 == 0 and 0 < _x:
            ans = 1
            for process in range(1 , _x + 1):
                ans = ans * process
            return ans
        if  _x < 0:
            return -factorial(-_x)
    return Gamma(_x + 1)

@__list
@__pow
@__memo
def sin(_θ, _n = 0):
    """
    "sin(θ)" returns value of sine θ.
    >>> hmath.sin(6)
    (-0.27941549819892586-0j)
    >>> hmath.sin(2.11)
    (0.8581178296348089+0j)
    >>> hmath.sin(53+12j)
    (32219.35761890742-74727.46166398648j)
    >>> hmath.sin([2.14, 25, 33+5j])
    [(0.8423304316366457+0j), (-0.13235175009777303-0j), (74.20340766788514-0.9851772699807544j)]
    """
    return (exp(_θ * 1j) - exp(_θ * -1j)) / 2j

@__list
@__pow
@__memo
def cos(_θ, _n = 0):
    """
    "cos(θ)" returns value of cosine θ.
    >>> hmath.cos(6)
    (0.960170286650366+0j)
    >>> hmath.cos(2.11)
    (-0.5134528123039594+0j)
    >>> hmath.cos(53+12j)
    (-74727.46166962861-32219.35761647477j)
    >>> hmath.cos([2.14, 25, 33+5j])
    [(-0.5389614493995115+0j), (0.9912028118634736+0j), (-0.9852667279998637-74.19667031476799j)]
    """
    return (exp(_θ * 1j) + exp(_θ * -1j)) / 2

@__list
@__pow
@__memo
def tan(_θ, _n = 0):
    """
    "tan(θ)" returns value of tangent θ.
    >>> hmath.tan(6)
    (-0.29100619138474915+0j)
    >>> hmath.tan(2.11)
    (-1.671269119715739-0j)
    >>> hmath.tan(53+12j)
    (-5.490123633255438e-11+0.9999999999481682j)
    >>> hmath.tan([2.14, 25, 33+5j])
    [(-1.5628769600778225-0j), (-0.13352640702153587+0j), (-2.411059897354615e-06+1.0000907719652579j)]
    """
    return div(sin(_θ) , cos(_θ))

@__list
@__pow
@__memo
def csc(_θ, _n = 0):
    """
    "csc(θ)" returns value of cosec θ.
    >>> hmath.csc(6)
    (-3.5788995472544056-0j)
    >>> hmath.csc(2.11)
    (1.1653411285319317+0j)
    >>> hmath.csc(53+12j)
    (4.865296397916956e-06+1.1284248877945188e-05j)
    >>> hmath.csc([2.14, 25, 33+5j])
    [(1.1871825621413237+0j), (-7.555623550585948-0j), (0.01347409494265443+0.00017889167746147676j)]
    """
    return div(1 , sin(_θ))

@__list
@__pow
@__memo
def sec(_θ, _n = 0):
    return div(1 , cos(_θ))

@__list
@__pow
@__memo
def cot(_θ, _n = 0):
    return div(1 , tan(_θ))

@__list
@__pow
@__memo
def asin(_x, _n = 0):
    return -1j * ln(1j * _x + square_root(1 - (_x ** 2)))

@__list
@__pow
@__memo
def acos(_x, _n = 0):
    return -1j * ln(_x - 1j * square_root(1 - (_x ** 2)))

@__list
@__pow
@__memo
def atan(_x, _n = 0):
    return 1j * (ln(1 - _x * 1j) - ln(1 + _x * 1j)) / 2

@__list
@__pow
@__memo
def acsc(_x, _n = 0):
    return asin(div(1 , _x))

@__list
@__pow
@__memo
def asec(_x, _n = 0):
    return acos(div(1 , _x))

@__list
@__pow
@__memo
def acot(_x, _n = 0):
    return atan(div(1 , _x))

@__list
@__pow
@__memo
def sinh(_x, _n = 0):
    return (exp(_x) - exp(0-_x)) / 2

@__list
@__pow
@__memo
def cosh(_x, _n = 0):
    return (exp(_x) + exp(0-_x)) / 2

@__list
@__pow
@__memo
def tanh(_x, _n = 0):
    return sinh(_x) / cosh(_x)

@__list
@__pow
@__memo
def csch(_x, _n = 0):
    return 1 / sinh(_x)

@__list
@__pow
@__memo
def sech(_x, _n = 0):
    return 1 / cosh(_x)

@__list
@__pow
@__memo
def coth(_x, _n = 0):
    return 1 / tanh(_x)

@__list
@__pow
@__memo
def asinh(_x, _n = 0):
    return ln(_x + square_root((_x ** 2) + 1))

@__list
@__pow
@__memo
def acosh(_x, _n = 0):
    return ln(_x + square_root((_x + 1) * (_x - 1)))

@__list
@__pow
@__memo
def atanh(_x, _n = 0):
    return ln((1 + _x) / (1 - _x)) / 2

@__list
@__pow
@__memo
def acsch(_x, _n = 0):
    return asinh(1 / _x)

@__list
@__pow
@__memo
def asech(_x, _n = 0):
    return acosh(1 / _x)

@__list
@__pow
@__memo
def acoth(_x, _n = 0):
    return atanh(1 / _x)

@__list
def radian(_θ):
    return _θ * 57.295779513082320876798154814105

@__list
def degrees(_θ):
    return _θ / 57.295779513082320876798154814105

@__list
@__pow
@__memo
def polyGamma(_x, _n = 0):
    return Gamma(_x, "d") / Gamma(_x)

B(300)