# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/01_ansicolor.ipynb.

# %% auto 0
__all__ = ['Fore', 'Back', 'Style', 'RESET_ALL', 'AnsiColor']

# %% ../nbs/01_ansicolor.ipynb 4
import re

from .color import enum, _EnumMeta, Color, hex2rgb
from .color import _ClassPropertyDescriptor


class _Style(_EnumMeta):
    reset_all =        (enum.auto(), '00', True)
    end =              (enum.auto(), '00', True)
    bold =             (enum.auto(), '01', True)
    no_bold =          (enum.auto(), '21', True)
    dim =              (enum.auto(), '02', False) # Not widely supported.
    faint =            (enum.auto(), '02', False) # Not widely supported.
    normal_intensity = (enum.auto(), '22', False)
    italic =           (enum.auto(), '03', False) # Not widely supported.
    no_italic =        (enum.auto(), '23', False)
    underline =        (enum.auto(), '04', True)
    no_underline =     (enum.auto(), '24', True)
    blink =            (enum.auto(), '05', True)
    no_blink =         (enum.auto(), '25', True)
    slow_blink =       (enum.auto(), '05', False)
    rapid_blink =      (enum.auto(), '06', False) # # Not widely supported.
    invert =           (enum.auto(), '07', True)
    no_invert =        (enum.auto(), '27', True)
    hidden =           (enum.auto(), '08', False) # Not widely supported.
    no_hidden =        (enum.auto(), '28', False)
    cross_out =        (enum.auto(), '09', False) # Not widely supported.
    strike =           (enum.auto(), '09', False) # Not widely supported.
    no_strike =        (enum.auto(), '29', False)
    
    def __init__(self, value, n, widely):
        self._value_ = value
        self._n = n
        self._widely = widely
        
    @property
    def n(self):
        return self._n
    
    @property
    def widely(self):
        return self._widely
    
    @_ClassPropertyDescriptor
    @classmethod
    def available(cls):
        return tuple(c.name for c in cls if c.widely)
    

class _AnsiColor:
    templates = dict(
        style = '\033[{0}m',
        fore = '\033[38;2;{0};{1};{2}m',
        back = '\033[48;2;{0};{1};{2}m',       
    )    
    
    def __init__(self, name='fore'):
        '''
        name: style, fore, back
        '''
        if name not in ('fore', 'back', 'style'):
            raise ValueError(f'Does not support {name}')
            
        self.name = name
        self._template = self.get_template(name=name)
        
        if name in ('fore', 'back'):
            for c in Color.available:
                setattr(self, c, self.rgb2ansi(Color[c].rgb))
                
            reset = '39' if name == 'fore' else '49'
            self.reset = f'\033[{reset}m'
            self.reset_all = '\033[00m'
            self.available = Color.available
        else:
            for c in _Style:
                if c.widely:
                #if 1:
                    setattr(self, c.name, self._template.format(c.n))
            self.available = _Style.available
            
    def __repr__(self):
        return f'<AnsiColor: \'{self.name.upper()}\'>'
    
    def __getitem__(self, name):
        return getattr(self, f'{name}', '') if name is not None else ''
    
    def __getattr__(self, name):
        return self.get_ansi(name)
    
    def __call__(self, name):
        if isinstance(name, (tuple, int)):
            name = f'{name}'
        return self[name]
    
    def __contains__(self, item):
        return item in self.available

    def get_ansi(self, color: str) -> str:
        if self.name in ('back', 'style'):
            color = color.lower()
        if color in self: return self.__dict__[color]
        elif self.name in ('fore', 'back'):
            # 8-bits
            if color.isdigit() and int(color) <= 255:
                code = 38 if self.name == 'fore' else '48'
                return self.get_8bit_ansi(code, color)

            # HEX 24-bits
            elif re.match(r'#(?:[a-f0-9]{3}){1,2}$', color):
                return self.hex2ansi(color)

            # 24-bits
            elif color.count(',') == 2:
                try:
                    color = eval(color)
                except:
                    return ''
                if all(int(x) <= 255 for x in color):
                    return self.rgb2ansi(color)
        return ''
    
    def get_8bit_ansi(self, code, color) -> str:
        return f'\033[{code};5;{color}m'
    
    def rgb2ansi(self, rgb: tuple) -> str:
        return self._template.format(*rgb)
    
    def hex2ansi(self, h: str) -> str:
        return self.rgb2ansi(hex2rgb(h))
    
    def get_template(self, name='style'):
        '''
        name: style, fore, back
        '''
        return self.templates[name]
    
    
Fore = _AnsiColor('fore')
Back = _AnsiColor('back')
Style = _AnsiColor('style')
RESET_ALL = '\033[00m'

class AnsiColor:
    r'''
    Integrate with `Fore`, `Back`, `Style`.
    
    Parameters
    ----------
    fore : `Fore`, str, int, optional
        Foreground color. Could be hex, rgb string or tuple, `Fore`, 8-bits color
        
    back : `Back`, str, rgb, int, optional
        Background color, Could be hex, rgb string or tuple, `Back`, 8-bits color
        
    style : `Style`, str, tuple, optional
        Text style. Seee `Style.available`.
        
    Examples
    --------
    >>> AnsiColor(fore='#ccccff', back=Back['red'], style='bold').ansi_fmt
    >>> '\x1b[38;2;204;204;255m\x1b[48;2;255;0;0m\x1b[01m'
    
    >>> AnsiColor(fore=Fore.blue, back=Back['(2, 2, 2)'], style='bold').ansi_fmt
    >>> '\x1b[38;2;0;0;255m\x1b[48;2;2;2;2m\x1b[01m'
    
    >>> ansi = AnsiColor(fore=Fore['0, 0, 0'], back=(2, 2, 2), style=('bold', 'underline'))
    >>> ansi.fore, ansi.back, ansi.style
    >>> ('\x1b[38;2;0;0;0m', '\x1b[48;2;2;2;2m', '\x1b[01m\x1b[04m')
    
    8-bits color:
    >>> ansi = AnsiColor(fore='108', back=177)
    >>> ansi.fore, ansi.back    
    >>> ('\x1b[38;5;108m', '\x1b[48;5;177m')
    '''
    
    def __init__(
        self, 
        fore: str = None, 
        back: str = None, 
        style: str = None
    ):
        self.fore = self.set_color(fore, Fore)
        self.back = self.set_color(back, Back)
        self.style = (
            ''.join(self.set_color(s, Style) for s in style) 
            if isinstance(style, (tuple, list)) else 
            self.set_color(style, Style)
        )
        self.ansi_fmt = f'{self.fore}{self.back}{self.style}'
        
    def set_color(self, color, Color):
        color = f'{color}'
        if color is None: return ''
        elif '[' in color: return color
        else: return Color[color]
