% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell_line_mapping.R
\name{ccle.to.arxspan}
\alias{ccle.to.arxspan}
\title{Map ccle names to Broad ID (aka ArxSpan IDs)}
\usage{
ccle.to.arxspan(ccle.names, ignore.problems = F, check.unique.mapping = T)
}
\arguments{
\item{ccle.names}{A vector of CCLE names}

\item{ignore.problems}{if not set to True, any unknown cell lines will result in an error being thrown. If you set to True, then you'll get NA for unknown lines instead.}

\item{check.unique.mapping}{if set, will throw an error if it discovers two different IDs which map to the same arxspan id (which could cause issues downstream)}
}
\description{
Map ccle names to Broad ID (aka ArxSpan IDs)
}
\examples{
broad_ids <- ccle.to.arxspan(c('HS294T_SKIN','NCIH1581_LUNG'))
}
