import { Construct, IConstruct } from "constructs";
import { Author } from "./author";
import { Threagile } from "./spec/threatgile.generated";
import { IModelSynthesizer } from "./synthesizer";
export interface ModelProps {
    /**
     * Version of the Threagile toolkit
     */
    readonly version: string;
    /**
     * Title of the model
     */
    readonly title?: string;
    /**
     * Date of the model
     */
    readonly date?: string;
    /**
     * Author of the model
     */
    readonly author: Author;
    /**
     * Individual management summary for the report
     */
    readonly managementSummary?: string;
    /**
     * Business criticality of the target
     */
    readonly businessCriticality: BusinessCriticality;
}
export declare class Model extends Construct {
    static isModel(x: any): x is Model;
    static of(construct: IConstruct): Model;
    readonly version: string;
    readonly title: string;
    readonly date?: string;
    readonly author: Author;
    readonly managementSummary?: string;
    readonly businessCriticality: BusinessCriticality;
    synthesizer: IModelSynthesizer;
    private readonly tags;
    private readonly rawOverrides;
    constructor(project: Construct, id: string, props: ModelProps);
    addTags(...tags: string[]): void;
    addOverride(path: string, value: unknown): void;
    /**
     * @internal
     */
    _toThreagile(): Threagile;
}
export declare enum BusinessCriticality {
    ARCHIVE = "archive",
    OPERATIONAL = "operational",
    IMPORTANT = "important",
    CRITICAL = "critical",
    MISSION_CRITICAL = "mission-critical"
}
