import { AnnotationMetadataEntryType } from "./annotations";
import { Model } from "./model";
export interface ModelAnnotation {
    readonly constructPath: string;
    readonly level: AnnotationMetadataEntryType;
    readonly message: string;
    readonly stacktrace?: string[];
}
export interface ModelManifest {
    readonly name: string;
    readonly sanitizedName: string;
    readonly constructPath: string;
    readonly synthesizedModelPath: string;
    readonly workingDirectory: string;
    readonly annotations: ModelAnnotation[];
}
export interface IManifest {
    readonly models: Record<ModelManifest["name"], ModelManifest>;
    readonly version: string;
}
export declare class Manifest implements IManifest {
    readonly version: string;
    readonly outdir: string;
    static readonly fileName = "manifest.json";
    static readonly modelsFolder = "models";
    static fromPath(dir: string): Manifest;
    readonly models: Record<ModelManifest["name"], ModelManifest>;
    constructor(version: string, outdir: string);
    forModel(model: Model): ModelManifest;
    buildManifest(): IManifest;
    writeToFile(): void;
}
