"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Authorization = exports.Authentication = exports.Protocol = exports.Communication = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
class Communication {
    constructor(id, props) {
        this.id = id;
        this.target = props.target;
        this.description = props.description;
        this.protocol = props.protocol;
        this.authentication = props.authentication;
        this.authorization = props.authorization;
        this.vpn = props.vpn;
        this.ipFiltered = props.ipFiltered;
        this.readonly = props.readonly;
        this.usage = props.usage;
        this.dataAssetsSent = new Set();
        this.dataAssetsReceived = new Set();
    }
    send(...assets) {
        assets.forEach((a) => {
            this.dataAssetsSent.add(a.uuid);
        });
    }
    receive(...assets) {
        assets.forEach((a) => {
            this.dataAssetsReceived.add(a.uuid);
        });
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.id]: {
                target: this.target.uuid,
                description: this.description,
                protocol: this.protocol,
                authentication: this.authentication,
                authorization: this.authorization,
                vpn: this.vpn,
                ipFiltered: this.ipFiltered,
                readonly: this.readonly,
                usage: this.usage,
                data_assets_sent: this.dataAssetsSent,
                data_assets_received: this.dataAssetsReceived,
            },
        };
    }
}
exports.Communication = Communication;
_a = JSII_RTTI_SYMBOL_1;
Communication[_a] = { fqn: "cdktg.Communication", version: "0.0.14" };
var Protocol;
(function (Protocol) {
    Protocol["UNKNOEN"] = "unknown-protocol";
    Protocol["HTTP"] = "http";
    Protocol["HTTPS"] = "https";
    Protocol["WS"] = "ws";
    Protocol["WSS"] = "wss";
    Protocol["REVERSE_PROXY_WEB_PROTOCOL"] = "reverse-proxy-web-protocol";
    Protocol["REVERSE_PROXY_WEB_PROTOCOL_ENCRYPTED"] = "reverse-proxy-web-protocol-encrypted";
    Protocol["MQTT"] = "mqtt";
    Protocol["JDBC"] = "jdbc";
    Protocol["JDBC_ENCRYPTED"] = "jdbc-encrypted";
    Protocol["ODBC"] = "odbc";
    Protocol["ODBC_ENCRYPTED"] = "odbc-encrypted";
    Protocol["SQL_ACCESS_PROTOCOL"] = "sql-access-protocol";
    Protocol["SQL_ACCESS_PROTOCOL_ENCRYPTED"] = "sql-access-protocol-encrypted";
    Protocol["NOSQL_ACCESS_PROTOCOL"] = "nosql-access-protocol";
    Protocol["NOSQL_ACCESS_PROTOCOL_ENCRYPTED"] = "nosql-access-protocol-encrypted";
    Protocol["BINARY"] = "binary";
    Protocol["BINARY_ENCRYPTED"] = "binary-encrypted";
    Protocol["TEXT"] = "text";
    Protocol["TEXT_ENCRYPTED"] = "text-encrypted";
    Protocol["SSH"] = "ssh";
    Protocol["SSH_TUNNEL"] = "ssh-tunnel";
    Protocol["SMTP"] = "smtp";
    Protocol["SMTP_ENCRYPTED"] = "smtp-encrypted";
    Protocol["POP3"] = "pop3";
    Protocol["POP3_ENCRYPTED"] = "pop3-encrypted";
    Protocol["IMAP"] = "imap";
    Protocol["IMAP_ENCRYPTED"] = "imap-encrypted";
    Protocol["FTP"] = "ftp";
    Protocol["FTPS"] = "ftps";
    Protocol["SFTP"] = "sftp";
    Protocol["SCP"] = "scp";
    Protocol["LDAP"] = "ldap";
    Protocol["LDAPS"] = "ldaps";
    Protocol["JMS"] = "jms";
    Protocol["NFS"] = "nfs";
    Protocol["SMB"] = "smb";
    Protocol["SMB_ENCRYPTED"] = "smb-encrypted";
    Protocol["LOCAL_FILE_ACCESS"] = "local-file-access";
    Protocol["NRPE"] = "nrpe";
    Protocol["XMPP"] = "xmpp";
    Protocol["IIOP"] = "iiop";
    Protocol["IIOP_ENCRYPTED"] = "iiop-encrypted";
    Protocol["JRMP"] = "jrmp";
    Protocol["JRMP_ENCRYPTED"] = "jrmp-encrypted";
    Protocol["IN_PROCESS_LIBRARY_CALL"] = "in-process-library-call";
    Protocol["CONTAINER_SPAWNING"] = "container-spawning";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
var Authentication;
(function (Authentication) {
    Authentication["NONE"] = "none";
    Authentication["CREDENTIALS"] = "credentials";
    Authentication["SESSION_ID"] = "session-id";
    Authentication["TOKEN"] = "token";
    Authentication["CLIENT_CERTIFICATE"] = "client-certificate";
    Authentication["TWO_FACTOR"] = "two-factor";
    Authentication["EXTERNALIZED"] = "externalized";
})(Authentication = exports.Authentication || (exports.Authentication = {}));
var Authorization;
(function (Authorization) {
    Authorization["NONE"] = "none";
    Authorization["TECHNICAL_USER"] = "technical-user";
    Authorization["ENDUSER_IDENTITY_PROPAGATION"] = "enduser-identity-propagation";
})(Authorization = exports.Authorization || (exports.Authorization = {}));
//# sourceMappingURL=data:application/json;base64,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