"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckCommand = void 0;
const path = require("path");
const threagile_1 = require("../api/threagile");
const manifest_1 = require("../manifest");
class CheckCommand {
    constructor() {
        this.command = "check";
        this.describe = "check the models";
        this.builder = (args) => {
            args.option("url", { type: "string", alias: "u", describe: "" });
            return args;
        };
        this.handler = async (args) => {
            const url = args.url ?? process.env.CDKTG_THREAGILE_BASE_URL;
            const api = new threagile_1.Threagile(url);
            const manifest = manifest_1.Manifest.fromPath(".cdktg.out");
            Object.keys(manifest.models).forEach(async (k) => {
                const modelManifest = manifest.models[k];
                const resp = await api.check(path.join(".cdktg.out", modelManifest.synthesizedModelPath));
                console.log(`Results for model "${modelManifest.name}":`);
                if (resp.status === 200) {
                    console.log(`✅  ${resp.data.message}\n`);
                }
                else {
                    console.log(`❌  ${resp.data.message}\n`);
                }
            });
        };
    }
}
exports.CheckCommand = CheckCommand;
//# sourceMappingURL=data:application/json;base64,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