"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Threagile = void 0;
const fs = require("fs-extra");
const generated_1 = require("./generated");
class Threagile {
    constructor(baseURL) {
        const configuration = new generated_1.Configuration({
            basePath: baseURL,
        });
        this.metaApi = new generated_1.MetaApi(configuration);
        this.directApi = new generated_1.DirectApi(configuration);
    }
    async ping() {
        return this.metaApi.metaPingGet();
    }
    async check(filename) {
        if (!fs.existsSync(filename)) {
            throw new Error(`File ${filename} not exist!`);
        }
        const file = fs.createReadStream(filename);
        return this.directApi.directCheckPost(file);
    }
    async analyse(filename, dpi = 120) {
        if (!fs.existsSync(filename)) {
            throw new Error(`File ${filename} not exist!`);
        }
        const file = fs.createReadStream(filename);
        return this.directApi.directAnalyzePost(dpi, file, {
            responseType: "arraybuffer",
        });
    }
}
exports.Threagile = Threagile;
//# sourceMappingURL=data:application/json;base64,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