<div align="center">
  <a href="https://pypi.org/project/configflow">
    <img alt="logo" src="https://github.com/volopivoshenko/configflow/blob/main/docs/_static/assets/logo.svg?raw=True" height=200>
  </a>
</div>

<p align="center">
  <a href="https://opensource.org/licenses/BSD-3-Clause">
    <img alt="license" src="https://img.shields.io/pypi/l/configflow?logo=opensourceinitiative">
  </a>
  <a href="https://pypi.org/project/configflow">
    <img alt="python" src="https://img.shields.io/pypi/pyversions/configflow?logo=python">
  </a>
  <a href="https://pypi.org/project/configflow">
    <img alt="pypi" src="https://img.shields.io/pypi/v/configflow?logo=pypi">
  </a>
  <a href="https://github.com/volopivoshenko/configflow/releases">
    <img alt="release" src="https://img.shields.io/github/v/release/volopivoshenko/configflow?logo=github">
  </a>
  <a href="https://www.sphinx-doc.org/en/master">
    <img alt="sphinx" src="https://img.shields.io/badge/made_with-Sphinx-1f425f.svg?logo=readthedocs">
  </a>
  <a href="https://numpydoc.readthedocs.io/en/latest/format.html">
    <img alt="numpydoc" src="https://img.shields.io/badge/docstrings-numpy-1f425f.svg?logo=numpy">
  </a>
</p>

<p align="center">
  <a href="https://github.com/psf/black">
    <img alt="black" src="https://img.shields.io/badge/code_style-black-black.svg?logo=windowsterminal">
  </a>
  <a href="https://pycqa.github.io/isort/index.html">
    <img alt="isort" src="https://img.shields.io/badge/imports-isort-black.svg?logo=windowsterminal">
  </a>
  <a href="https://wemake-python-stylegui.de/en/latest/index.html">
    <img alt="wemake" src="https://img.shields.io/badge/style-wemake-black.svg?logo=windowsterminal">
  </a>
  <a href="https://mypy.readthedocs.io/en/stable/index.html">
    <img alt="mypy" src="https://img.shields.io/badge/mypy-checked-success.svg?logo=python">
  </a>
  <a href="https://github.com/pyupio/safety">
    <img alt="safety" src="https://img.shields.io/badge/safety-checked-success.svg?logo=windowsterminal">
  </a>
  <a href="https://github.com/semantic-release/semantic-release">
    <img alt="semantic_release" src="https://img.shields.io/badge/semantic_release-angular-e10079?logo=semantic-release">
  </a>
</p>

<p align="center">
  <a href="https://github.com/dependabot">
    <img alt="dependabot" src="https://img.shields.io/badge/dependabot-enable-success?logo=Dependabot">
  </a>
  <a href="https://github.com/volopivoshenko/configflow/actions/workflows/integration.yaml">
    <img alt="integration" src="https://img.shields.io/github/workflow/status/volopivoshenko/configflow/Integration?label=integration&logo=github">
  </a>
  <a href="https://github.com/volopivoshenko/configflow/actions/workflows/deployment.yaml">
    <img alt="deployment" src="https://img.shields.io/github/workflow/status/volopivoshenko/configflow/Deployment?label=deployment&logo=github">
  </a>
  <a href="https://github.com/volopivoshenko/configflow/actions/workflows/codeql.yaml">
    <img alt="codeql" src="https://img.shields.io/github/workflow/status/volopivoshenko/configflow/CodeQL?label=codeQL&logo=github">
  </a>
  <a href="https://configflow.readthedocs.io/en/latest">
    <img alt="docs" src="https://img.shields.io/readthedocs/configflow?logo=readthedocs">
  </a>
  <a href="https://pypi.org/project/configflow">
    <img alt="wheel" src="https://img.shields.io/pypi/wheel/configflow?logo=pypi">
  </a>
</p>

<p align="center">
  <a href="https://codecov.io/gh/volopivoshenko/configflow">
    <img alt="coverage" src="https://img.shields.io/codecov/c/gh/volopivoshenko/configflow?logo=codecov&token=yyck08xfTN"/>
  </a>
  <a href="https://lgtm.com/projects/g/volopivoshenko/configflow/alerts/">
    <img alt="alerts" src="https://img.shields.io/lgtm/alerts/github/volopivoshenko/configflow?logo=lgtm"/>
  </a>
  <a href="https://lgtm.com/projects/g/volopivoshenko/configflow/context:python">
    <img alt="grade" src="https://img.shields.io/lgtm/grade/python/github/volopivoshenko/configflow?logo=lgtm"/>
  </a>
  <a href="https://codeclimate.com/github/volopivoshenko/configflow/maintainability">
    <img alt="codeclimate" src="https://img.shields.io/codeclimate/maintainability/volopivoshenko/configflow?logo=codeclimate">
  </a>
  <a href="https://pypi.org/project/configflow">
    <img alt="downloads" src="https://img.shields.io/pypi/dm/configflow?logo=pypi">
  </a>
  <a href="https://github.com/volopivoshenko/configflow/">
    <img alt="stars" src="https://img.shields.io/github/stars/volopivoshenko/configflow?logo=github">
  </a>
</p>

<p align="center">
  <a href="https://github.com/volopivoshenko/configflow/issues">
    <img alt="issues" src="https://img.shields.io/github/issues/volopivoshenko/configflow?logo=github">
  </a>
  <a href="https://github.com/volopivoshenko/configflow/issues">
    <img alt="issues" src="https://img.shields.io/github/issues-closed/volopivoshenko/configflow?logo=github">
  </a>
  <a href="https://github.com/volopivoshenko/configflow/pulls">
    <img alt="pr" src="https://img.shields.io/github/issues-pr/volopivoshenko/configflow?logo=github">
  </a>
  <a href="https://github.com/volopivoshenko/configflow/pulls">
    <img alt="pr" src="https://img.shields.io/github/issues-pr-closed/volopivoshenko/configflow?logo=github">
  </a>
  <a href="https://github.com/volopivoshenko/configflow/graphs/contributors">
    <img alt="contributors" src="https://img.shields.io/github/contributors/volopivoshenko/configflow?logo=github">
  </a>
  <a href="https://github.com/volopivoshenko/configflow/commits/main">
    <img alt="commit" src="https://img.shields.io/github/last-commit/volopivoshenko/configflow?logo=github">
  </a>

</p>

<p align="center">
  <a href="https://www.buymeacoffee.com/volo.pivoshenko" target="_blank">
    <img alt="buymeacoffee" src="https://img.shields.io/badge/buy_me_-a_coffee-ff6964?logo=buymeacoffee">
  </a>
</p>

# Overview

- [Overview](#overview)
- [Installation](#installation)
  - [Optional dependencies](#optional-dependencies)
- [Examples](#examples)
- [See Also](#see-also)

`configflow` – is the configuration management package.

# Installation

Installation is as simple as:

```shell
pip install -U configflow

poetry add configflow
```

### Optional dependencies

`configflow` has next optional dependencies:

- If you are using [`Vault by HashiCorp`][vault] as a config source you can add [`hvac`][hvac].

To install these along with `configflow`:

```bash

pip install -U "configflow[hvac]"

poetry add "configflow[hvac]"
```

Of course, you can also install these requirements manually with `pip install ... | poetry add ...`.

# Examples

# See Also

[vault]: https://www.vaultproject.io/
[hvac]: https://pypi.org/project/hvac
