# coding: utf-8

"""
    Pure Storage FlashBlade REST 1.9 Python SDK

    Pure Storage FlashBlade REST 1.9 Python SDK, developed by [Pure Storage, Inc](http://www.purestorage.com/). Documentations can be found at [purity-fb.readthedocs.io](http://purity-fb.readthedocs.io/).

    OpenAPI spec version: 1.9
    Contact: info@purestorage.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class FileSystemSnapshotsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_file_system_snapshots(self, **kwargs):
        """
        Create snapshots for the specified source file systems.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_file_system_snapshots(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] sources: A comma-separated list of names of source file systems.
        :param list[str] source_ids: A comma-separated list of IDs of source file systems.
        :param bool send: Whether to replicate created snapshots immediately to other arrays. If it's false, created snapshots may still be replicated to other arrays according to policy.
        :param list[str] targets: A comma-separated list of targets arrays to replicate created snapshots to. Only valid when send is true.
        :param SnapshotSuffix suffix: the suffix of the snapshot
        :return: FileSystemSnapshotResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_file_system_snapshots_with_http_info(**kwargs)
        else:
            (data) = self.create_file_system_snapshots_with_http_info(**kwargs)
            return data

    def create_file_system_snapshots_with_http_info(self, **kwargs):
        """
        Create snapshots for the specified source file systems.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_file_system_snapshots_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] sources: A comma-separated list of names of source file systems.
        :param list[str] source_ids: A comma-separated list of IDs of source file systems.
        :param bool send: Whether to replicate created snapshots immediately to other arrays. If it's false, created snapshots may still be replicated to other arrays according to policy.
        :param list[str] targets: A comma-separated list of targets arrays to replicate created snapshots to. Only valid when send is true.
        :param SnapshotSuffix suffix: the suffix of the snapshot
        :return: FileSystemSnapshotResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sources', 'source_ids', 'send', 'targets', 'suffix']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_file_system_snapshots" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sources' in params:
            query_params.append(('sources', params['sources']))
            collection_formats['sources'] = 'csv'
        if 'source_ids' in params:
            query_params.append(('source_ids', params['source_ids']))
            collection_formats['source_ids'] = 'csv'
        if 'send' in params:
            query_params.append(('send', params['send']))
        if 'targets' in params:
            query_params.append(('targets', params['targets']))
            collection_formats['targets'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'suffix' in params:
            body_params = params['suffix']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.9/file-system-snapshots', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FileSystemSnapshotResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_file_system_snapshots(self, **kwargs):
        """
        Delete a file system snapshot.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_file_system_snapshots(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param str name: The name of the file system or snapshot to be updated.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_file_system_snapshots_with_http_info(**kwargs)
        else:
            (data) = self.delete_file_system_snapshots_with_http_info(**kwargs)
            return data

    def delete_file_system_snapshots_with_http_info(self, **kwargs):
        """
        Delete a file system snapshot.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_file_system_snapshots_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param str name: The name of the file system or snapshot to be updated.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ids', 'name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file_system_snapshots" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ids' in params:
            query_params.append(('ids', params['ids']))
            collection_formats['ids'] = 'csv'
        if 'name' in params:
            query_params.append(('name', params['name']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.9/file-system-snapshots', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_file_system_snapshots_transfer(self, **kwargs):
        """
        Cancel not completed snapshot transfers.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_file_system_snapshots_transfer(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param list[str] names: A comma-separated list of resource names. This cannot be provided together with the ids query parameters.
        :param list[str] remote_ids: A comma-separated list of remote array IDs. This cannot be provided together with the `remote_names` query parameter.
        :param list[str] remote_names: A comma-separated list of remote array names. This cannot be provided together with `remote_ids` query parameter.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_file_system_snapshots_transfer_with_http_info(**kwargs)
        else:
            (data) = self.delete_file_system_snapshots_transfer_with_http_info(**kwargs)
            return data

    def delete_file_system_snapshots_transfer_with_http_info(self, **kwargs):
        """
        Cancel not completed snapshot transfers.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_file_system_snapshots_transfer_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param list[str] names: A comma-separated list of resource names. This cannot be provided together with the ids query parameters.
        :param list[str] remote_ids: A comma-separated list of remote array IDs. This cannot be provided together with the `remote_names` query parameter.
        :param list[str] remote_names: A comma-separated list of remote array names. This cannot be provided together with `remote_ids` query parameter.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ids', 'names', 'remote_ids', 'remote_names']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file_system_snapshots_transfer" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ids' in params:
            query_params.append(('ids', params['ids']))
            collection_formats['ids'] = 'csv'
        if 'names' in params:
            query_params.append(('names', params['names']))
            collection_formats['names'] = 'csv'
        if 'remote_ids' in params:
            query_params.append(('remote_ids', params['remote_ids']))
            collection_formats['remote_ids'] = 'csv'
        if 'remote_names' in params:
            query_params.append(('remote_names', params['remote_names']))
            collection_formats['remote_names'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.9/file-system-snapshots/transfer', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_filesystem_snapshot_policies(self, **kwargs):
        """
        Delete a connection betwwen a file system snapshot and a policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_filesystem_snapshot_policies(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] member_names: A comma-separated list of member names. This cannot be provided together with the member ids query parameters.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_filesystem_snapshot_policies_with_http_info(**kwargs)
        else:
            (data) = self.delete_filesystem_snapshot_policies_with_http_info(**kwargs)
            return data

    def delete_filesystem_snapshot_policies_with_http_info(self, **kwargs):
        """
        Delete a connection betwwen a file system snapshot and a policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_filesystem_snapshot_policies_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] member_names: A comma-separated list of member names. This cannot be provided together with the member ids query parameters.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_ids', 'policy_names', 'member_ids', 'member_names']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_filesystem_snapshot_policies" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'policy_ids' in params:
            query_params.append(('policy_ids', params['policy_ids']))
            collection_formats['policy_ids'] = 'csv'
        if 'policy_names' in params:
            query_params.append(('policy_names', params['policy_names']))
            collection_formats['policy_names'] = 'csv'
        if 'member_ids' in params:
            query_params.append(('member_ids', params['member_ids']))
            collection_formats['member_ids'] = 'csv'
        if 'member_names' in params:
            query_params.append(('member_names', params['member_names']))
            collection_formats['member_names'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.9/file-system-snapshots/policies', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_file_system_snapshots(self, **kwargs):
        """
        List file system snapshots.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_file_system_snapshots(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str filter: The filter to be used for query.
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param str sort: The way to order the results.
        :param int start: start
        :param int limit: limit, should be >= 0
        :param str token: token
        :param bool total: Return a total object in addition to the other results.
        :param bool total_only: Return only the total object.
        :param list[str] names_or_sources: A comma-separated list of resource names. Either the name of the snapshot or the source file system.
        :param list[str] names_or_owner_names: A comma-separated list of resource names. Either the name of the snapshot or the owning file system.
        :param list[str] source_ids: A comma-separated list of IDs of source file systems.
        :param list[str] owner_ids: A comma-separated list of IDs of owning file systems.
        :return: FileSystemSnapshotResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_file_system_snapshots_with_http_info(**kwargs)
        else:
            (data) = self.list_file_system_snapshots_with_http_info(**kwargs)
            return data

    def list_file_system_snapshots_with_http_info(self, **kwargs):
        """
        List file system snapshots.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_file_system_snapshots_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str filter: The filter to be used for query.
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param str sort: The way to order the results.
        :param int start: start
        :param int limit: limit, should be >= 0
        :param str token: token
        :param bool total: Return a total object in addition to the other results.
        :param bool total_only: Return only the total object.
        :param list[str] names_or_sources: A comma-separated list of resource names. Either the name of the snapshot or the source file system.
        :param list[str] names_or_owner_names: A comma-separated list of resource names. Either the name of the snapshot or the owning file system.
        :param list[str] source_ids: A comma-separated list of IDs of source file systems.
        :param list[str] owner_ids: A comma-separated list of IDs of owning file systems.
        :return: FileSystemSnapshotResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'ids', 'sort', 'start', 'limit', 'token', 'total', 'total_only', 'names_or_sources', 'names_or_owner_names', 'source_ids', 'owner_ids']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_file_system_snapshots" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'ids' in params:
            query_params.append(('ids', params['ids']))
            collection_formats['ids'] = 'csv'
        if 'sort' in params:
            query_params.append(('sort', params['sort']))
        if 'start' in params:
            query_params.append(('start', params['start']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'token' in params:
            query_params.append(('token', params['token']))
        if 'total' in params:
            query_params.append(('total', params['total']))
        if 'total_only' in params:
            query_params.append(('total_only', params['total_only']))
        if 'names_or_sources' in params:
            query_params.append(('names_or_sources', params['names_or_sources']))
            collection_formats['names_or_sources'] = 'csv'
        if 'names_or_owner_names' in params:
            query_params.append(('names_or_owner_names', params['names_or_owner_names']))
            collection_formats['names_or_owner_names'] = 'csv'
        if 'source_ids' in params:
            query_params.append(('source_ids', params['source_ids']))
            collection_formats['source_ids'] = 'csv'
        if 'owner_ids' in params:
            query_params.append(('owner_ids', params['owner_ids']))
            collection_formats['owner_ids'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.9/file-system-snapshots', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FileSystemSnapshotResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_file_system_snapshots_transfer(self, **kwargs):
        """
        List file system snapshot transfer records
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_file_system_snapshots_transfer(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param str filter: The filter to be used for query.
        :param str sort: The way to order the results.
        :param int start: start
        :param int limit: limit, should be >= 0
        :param str token: token
        :param bool total: Return a total object in addition to the other results.
        :param bool total_only: Return only the total object.
        :param list[str] names_or_owner_names: A comma-separated list of resource names. Either the name of the snapshot or the owning file system.
        :return: FileSystemSnapshotTransferResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_file_system_snapshots_transfer_with_http_info(**kwargs)
        else:
            (data) = self.list_file_system_snapshots_transfer_with_http_info(**kwargs)
            return data

    def list_file_system_snapshots_transfer_with_http_info(self, **kwargs):
        """
        List file system snapshot transfer records
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_file_system_snapshots_transfer_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param str filter: The filter to be used for query.
        :param str sort: The way to order the results.
        :param int start: start
        :param int limit: limit, should be >= 0
        :param str token: token
        :param bool total: Return a total object in addition to the other results.
        :param bool total_only: Return only the total object.
        :param list[str] names_or_owner_names: A comma-separated list of resource names. Either the name of the snapshot or the owning file system.
        :return: FileSystemSnapshotTransferResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ids', 'filter', 'sort', 'start', 'limit', 'token', 'total', 'total_only', 'names_or_owner_names']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_file_system_snapshots_transfer" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ids' in params:
            query_params.append(('ids', params['ids']))
            collection_formats['ids'] = 'csv'
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'sort' in params:
            query_params.append(('sort', params['sort']))
        if 'start' in params:
            query_params.append(('start', params['start']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'token' in params:
            query_params.append(('token', params['token']))
        if 'total' in params:
            query_params.append(('total', params['total']))
        if 'total_only' in params:
            query_params.append(('total_only', params['total_only']))
        if 'names_or_owner_names' in params:
            query_params.append(('names_or_owner_names', params['names_or_owner_names']))
            collection_formats['names_or_owner_names'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.9/file-system-snapshots/transfer', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FileSystemSnapshotTransferResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_filesystem_snapshot_policies(self, **kwargs):
        """
        List policies attached to filesystem snapshots.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_filesystem_snapshot_policies(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] member_names: A comma-separated list of member names. This cannot be provided together with the member ids query parameters.
        :param str filter: The filter to be used for query.
        :param str sort: The way to order the results.
        :param int start: start
        :param int limit: limit, should be >= 0
        :param str token: token
        :return: PolicyMemberResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_filesystem_snapshot_policies_with_http_info(**kwargs)
        else:
            (data) = self.list_filesystem_snapshot_policies_with_http_info(**kwargs)
            return data

    def list_filesystem_snapshot_policies_with_http_info(self, **kwargs):
        """
        List policies attached to filesystem snapshots.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_filesystem_snapshot_policies_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] member_names: A comma-separated list of member names. This cannot be provided together with the member ids query parameters.
        :param str filter: The filter to be used for query.
        :param str sort: The way to order the results.
        :param int start: start
        :param int limit: limit, should be >= 0
        :param str token: token
        :return: PolicyMemberResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_ids', 'policy_names', 'member_ids', 'member_names', 'filter', 'sort', 'start', 'limit', 'token']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_filesystem_snapshot_policies" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'policy_ids' in params:
            query_params.append(('policy_ids', params['policy_ids']))
            collection_formats['policy_ids'] = 'csv'
        if 'policy_names' in params:
            query_params.append(('policy_names', params['policy_names']))
            collection_formats['policy_names'] = 'csv'
        if 'member_ids' in params:
            query_params.append(('member_ids', params['member_ids']))
            collection_formats['member_ids'] = 'csv'
        if 'member_names' in params:
            query_params.append(('member_names', params['member_names']))
            collection_formats['member_names'] = 'csv'
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'sort' in params:
            query_params.append(('sort', params['sort']))
        if 'start' in params:
            query_params.append(('start', params['start']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'token' in params:
            query_params.append(('token', params['token']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.9/file-system-snapshots/policies', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PolicyMemberResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_file_system_snapshots(self, attributes, **kwargs):
        """
        Update an existing file system snapshot.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_file_system_snapshots(attributes, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SnapshotSuffix attributes: The new attributes, only modifiable fields may be specified. (required)
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param str name: The name of the file system or snapshot to be updated.
        :param bool latest_replica: Used when destroying a snapshot. If not present or false, and the snapshot is the latest replicated snapshot, then destroy will fail. If true or the snapshot is not the latest replicated snapshot, then destroy will be successful.
        :return: FileSystemSnapshotResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_file_system_snapshots_with_http_info(attributes, **kwargs)
        else:
            (data) = self.update_file_system_snapshots_with_http_info(attributes, **kwargs)
            return data

    def update_file_system_snapshots_with_http_info(self, attributes, **kwargs):
        """
        Update an existing file system snapshot.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_file_system_snapshots_with_http_info(attributes, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SnapshotSuffix attributes: The new attributes, only modifiable fields may be specified. (required)
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param str name: The name of the file system or snapshot to be updated.
        :param bool latest_replica: Used when destroying a snapshot. If not present or false, and the snapshot is the latest replicated snapshot, then destroy will fail. If true or the snapshot is not the latest replicated snapshot, then destroy will be successful.
        :return: FileSystemSnapshotResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['attributes', 'ids', 'name', 'latest_replica']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_file_system_snapshots" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'attributes' is set
        if ('attributes' not in params) or (params['attributes'] is None):
            raise ValueError("Missing the required parameter `attributes` when calling `update_file_system_snapshots`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ids' in params:
            query_params.append(('ids', params['ids']))
            collection_formats['ids'] = 'csv'
        if 'name' in params:
            query_params.append(('name', params['name']))
        if 'latest_replica' in params:
            query_params.append(('latest_replica', params['latest_replica']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'attributes' in params:
            body_params = params['attributes']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.9/file-system-snapshots', 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FileSystemSnapshotResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
