"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from moovio_sdk.models.components import incurredfee as components_incurredfee
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class RetrieveFeesGlobalsTypedDict(TypedDict):
    x_moov_version: NotRequired[str]
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    """


class RetrieveFeesGlobals(BaseModel):
    x_moov_version: Annotated[
        Optional[str],
        pydantic.Field(alias="x-moov-version"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = "v2024.01.00"
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    """


class RetrieveFeesRequestTypedDict(TypedDict):
    account_id: str
    transfer_id: NotRequired[str]
    r"""Optional transfer ID to filter the results by."""
    dispute_id: NotRequired[str]
    r"""Optional dispute ID to filter the results by."""
    start_date_time: NotRequired[str]
    r"""Optional date-time to inclusively filter all fees created after this date-time."""
    end_date_time: NotRequired[str]
    r"""Optional date-time to exclusively filter all fees created before this date-time."""
    skip: NotRequired[int]
    count: NotRequired[int]


class RetrieveFeesRequest(BaseModel):
    account_id: Annotated[
        str,
        pydantic.Field(alias="accountID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]

    transfer_id: Annotated[
        Optional[str],
        pydantic.Field(alias="transferID"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional transfer ID to filter the results by."""

    dispute_id: Annotated[
        Optional[str],
        pydantic.Field(alias="disputeID"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional dispute ID to filter the results by."""

    start_date_time: Annotated[
        Optional[str],
        pydantic.Field(alias="startDateTime"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional date-time to inclusively filter all fees created after this date-time."""

    end_date_time: Annotated[
        Optional[str],
        pydantic.Field(alias="endDateTime"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional date-time to exclusively filter all fees created before this date-time."""

    skip: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    count: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None


class RetrieveFeesResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: List[components_incurredfee.IncurredFeeTypedDict]


class RetrieveFeesResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: List[components_incurredfee.IncurredFee]
