"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import FieldMetadata, HeaderMetadata, PathParamMetadata
import pydantic
from typing import Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class GetDisputeEvidenceDataGlobalsTypedDict(TypedDict):
    x_moov_version: NotRequired[str]
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    """


class GetDisputeEvidenceDataGlobals(BaseModel):
    x_moov_version: Annotated[
        Optional[str],
        pydantic.Field(alias="x-moov-version"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = "v2024.01.00"
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    """


class GetDisputeEvidenceDataRequestTypedDict(TypedDict):
    account_id: str
    dispute_id: str
    evidence_id: str


class GetDisputeEvidenceDataRequest(BaseModel):
    account_id: Annotated[
        str,
        pydantic.Field(alias="accountID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]

    dispute_id: Annotated[
        str,
        pydantic.Field(alias="disputeID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]

    evidence_id: Annotated[
        str,
        pydantic.Field(alias="evidenceID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]


GetDisputeEvidenceDataResponseResultTypedDict = TypeAliasType(
    "GetDisputeEvidenceDataResponseResultTypedDict",
    Union[httpx.Response, httpx.Response, httpx.Response],
)


GetDisputeEvidenceDataResponseResult = TypeAliasType(
    "GetDisputeEvidenceDataResponseResult",
    Union[httpx.Response, httpx.Response, httpx.Response],
)


class GetDisputeEvidenceDataResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: GetDisputeEvidenceDataResponseResultTypedDict


class GetDisputeEvidenceDataResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: GetDisputeEvidenceDataResponseResult
