"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from moovio_sdk.models.components import (
    asynctransfer as components_asynctransfer,
    createdtransfer as components_createdtransfer,
    createtransfer as components_createtransfer,
    transfer as components_transfer,
    transferwaitfor as components_transferwaitfor,
)
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    RequestMetadata,
)
import pydantic
from typing import Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class CreateTransferGlobalsTypedDict(TypedDict):
    x_moov_version: NotRequired[str]
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    """


class CreateTransferGlobals(BaseModel):
    x_moov_version: Annotated[
        Optional[str],
        pydantic.Field(alias="x-moov-version"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = "v2024.01.00"
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    """


class CreateTransferRequestTypedDict(TypedDict):
    x_idempotency_key: str
    r"""Prevents duplicate transfers from being created."""
    account_id: str
    r"""Your Moov account ID."""
    create_transfer: components_createtransfer.CreateTransferTypedDict
    x_wait_for: NotRequired[components_transferwaitfor.TransferWaitFor]
    r"""Optional header that indicates whether to return a synchronous response that includes full transfer and rail-specific details or an
    asynchronous response indicating the transfer was created (this is the default response if the header is omitted). A timeout will occur after 15 seconds.
    """


class CreateTransferRequest(BaseModel):
    x_idempotency_key: Annotated[
        str,
        pydantic.Field(alias="x-idempotency-key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ]
    r"""Prevents duplicate transfers from being created."""

    account_id: Annotated[
        str,
        pydantic.Field(alias="accountID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Your Moov account ID."""

    create_transfer: Annotated[
        components_createtransfer.CreateTransfer,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    x_wait_for: Annotated[
        Optional[components_transferwaitfor.TransferWaitFor],
        pydantic.Field(alias="x-wait-for"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Optional header that indicates whether to return a synchronous response that includes full transfer and rail-specific details or an
    asynchronous response indicating the transfer was created (this is the default response if the header is omitted). A timeout will occur after 15 seconds.
    """


CreateTransferResponseResultTypedDict = TypeAliasType(
    "CreateTransferResponseResultTypedDict",
    Union[
        components_asynctransfer.AsyncTransferTypedDict,
        components_createdtransfer.CreatedTransferTypedDict,
        components_transfer.TransferTypedDict,
    ],
)


CreateTransferResponseResult = TypeAliasType(
    "CreateTransferResponseResult",
    Union[
        components_asynctransfer.AsyncTransfer,
        components_createdtransfer.CreatedTransfer,
        components_transfer.Transfer,
    ],
)


class CreateTransferResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: CreateTransferResponseResultTypedDict


class CreateTransferResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: CreateTransferResponseResult
