"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from moovio_sdk.models.errors import MoovError
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated


class TransferValidationErrorData(BaseModel):
    transfer: Annotated[Optional[str], pydantic.Field(alias="Transfer")] = None

    amount: Optional[str] = None

    source: Optional[str] = None

    source_payment_method_id: Annotated[
        Optional[str], pydantic.Field(alias="sourcePaymentMethodID")
    ] = None

    destination_payment_method_id: Annotated[
        Optional[str], pydantic.Field(alias="destinationPaymentMethodID")
    ] = None

    description: Optional[str] = None

    facilitator_fee_total_decimal: Annotated[
        Optional[str], pydantic.Field(alias="FacilitatorFee.TotalDecimal")
    ] = None

    facilitator_fee_markup_decimal: Annotated[
        Optional[str], pydantic.Field(alias="FacilitatorFee.MarkupDecimal")
    ] = None

    metadata: Optional[str] = None

    error: Optional[str] = None
    r"""Used for generic errors when invalid request data isn't attributed to a single request field."""


class TransferValidationError(MoovError):
    data: TransferValidationErrorData

    def __init__(
        self,
        data: TransferValidationErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data
