"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from moovio_sdk.models.components import (
    addresserror as components_addresserror,
    birthdatevalidationerror as components_birthdatevalidationerror,
    governmentiderror as components_governmentiderror,
    individualnameerror as components_individualnameerror,
    phonenumbererror as components_phonenumbererror,
    representativeresponsibilitieserror as components_representativeresponsibilitieserror,
)
from moovio_sdk.models.errors import MoovError
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ErrorTypedDict(TypedDict):
    name: NotRequired[components_individualnameerror.IndividualNameErrorTypedDict]
    phone: NotRequired[components_phonenumbererror.PhoneNumberErrorTypedDict]
    email: NotRequired[str]
    address: NotRequired[components_addresserror.AddressErrorTypedDict]
    birth_date: NotRequired[
        components_birthdatevalidationerror.BirthDateValidationErrorTypedDict
    ]
    government_id: NotRequired[components_governmentiderror.GovernmentIDErrorTypedDict]
    responsibilities: NotRequired[
        components_representativeresponsibilitieserror.RepresentativeResponsibilitiesErrorTypedDict
    ]


class Error(BaseModel):
    name: Optional[components_individualnameerror.IndividualNameError] = None

    phone: Optional[components_phonenumbererror.PhoneNumberError] = None

    email: Optional[str] = None

    address: Optional[components_addresserror.AddressError] = None

    birth_date: Annotated[
        Optional[components_birthdatevalidationerror.BirthDateValidationError],
        pydantic.Field(alias="birthDate"),
    ] = None

    government_id: Annotated[
        Optional[components_governmentiderror.GovernmentIDError],
        pydantic.Field(alias="governmentID"),
    ] = None

    responsibilities: Optional[
        components_representativeresponsibilitieserror.RepresentativeResponsibilitiesError
    ] = None


class RepresentativeValidationErrorData(BaseModel):
    error: Error


class RepresentativeValidationError(MoovError):
    data: RepresentativeValidationErrorData

    def __init__(
        self,
        data: RepresentativeValidationErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data
