"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
import httpx
from moovio_sdk.models.components import (
    amount as components_amount,
    refundcarddetails as components_refundcarddetails,
    refundstatus as components_refundstatus,
)
from moovio_sdk.models.errors import MoovError
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated


class CardAcquiringRefundData(BaseModel):
    refund_id: Annotated[str, pydantic.Field(alias="refundID")]
    r"""Identifier for the refund."""

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]

    updated_on: Annotated[datetime, pydantic.Field(alias="updatedOn")]

    status: components_refundstatus.RefundStatus

    amount: components_amount.Amount

    card_details: Annotated[
        Optional[components_refundcarddetails.RefundCardDetails],
        pydantic.Field(alias="cardDetails"),
    ] = None


class CardAcquiringRefund(MoovError):
    r"""Details of a card refund."""

    data: CardAcquiringRefundData

    def __init__(
        self,
        data: CardAcquiringRefundData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data
