"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .webhookdata import WebhookData, WebhookDataTypedDict
from .webhookeventtype import WebhookEventType
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing_extensions import Annotated, TypedDict


class WebhookEventTypedDict(TypedDict):
    r"""Webhook events are sent to your webhook URL when certain actions occur in the Moov API. You can subscribe to these events to receive real-time notifications."""

    event_id: str
    r"""Unique identifier for the webhook event."""
    type: WebhookEventType
    r"""The type of event that occurred."""
    data: WebhookDataTypedDict
    r"""The data for the webhook event. The contents are based on the event type."""
    created_on: datetime


class WebhookEvent(BaseModel):
    r"""Webhook events are sent to your webhook URL when certain actions occur in the Moov API. You can subscribe to these events to receive real-time notifications."""

    event_id: Annotated[str, pydantic.Field(alias="eventID")]
    r"""Unique identifier for the webhook event."""

    type: WebhookEventType
    r"""The type of event that occurred."""

    data: WebhookData
    r"""The data for the webhook event. The contents are based on the event type."""

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]
