"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .wallettransactionsourcetype import WalletTransactionSourceType
from .wallettransactionstatus import WalletTransactionStatus
from .wallettransactiontype import WalletTransactionType
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class WalletTransactionTypedDict(TypedDict):
    r"""A transaction that funds or deducts from the wallet."""

    wallet_id: str
    transaction_id: str
    transaction_type: WalletTransactionType
    source_type: WalletTransactionSourceType
    source_id: str
    r"""The ID of the Moov object to which this transaction is related."""
    status: WalletTransactionStatus
    memo: str
    r"""Detailed description of the transaction."""
    created_on: datetime
    currency: str
    r"""A 3-letter ISO 4217 currency code."""
    gross_amount: int
    r"""The total transaction amount. The amount is in the smallest unit of the specified currency. In USD this is cents, for example, $12.04 is 1204 and $0.99 is 99."""
    gross_amount_decimal: str
    r"""The total transaction amount. Same as `grossAmount`, but a decimal-formatted numerical string that represents up to 9 decimal place precision. In USD for example, 12.987654321 is $12.987654321 and 0.9987634521 is $0.9987634521."""
    fee: int
    r"""Total fees paid for the transaction. The value is in the smallest unit of the specified currency. In USD this is cents, for example, $12.04 is 1204 and $0.99 is 99."""
    fee_decimal: str
    r"""Total fees paid for the transaction. Same as `fee`, but a decimal-formatted numerical string that represents up to 9 decimal place precision. In USD for example, 12.987654321 is $12.987654321 and 0.9987634521 is $0.9987634521."""
    net_amount: int
    r"""Net amount is the gross amount less fees paid, and the amount that affects the wallet's balance. The amount is in the smallest unit of the specified currency. In USD this is cents, for example, $12.04 is 1204 and $0.99 is 99."""
    net_amount_decimal: str
    r"""Net amount is the gross amount less fees paid, and the amount that affects the wallet's balance. Same as `netAmount`, but a decimal-formatted numerical string that represents up to 9 decimal place precision. In USD for example, 12.987654321 is $12.987654321 and 0.9987634521 is $0.9987634521."""
    completed_on: NotRequired[datetime]
    fee_i_ds: NotRequired[List[str]]
    r"""The IDs of the fees paid for the transaction."""
    available_balance: NotRequired[int]
    r"""The wallet's total available balance after recording a completed transaction. The value is in the smallest unit of the specified currency. In USD this is cents, for example, $12.04 is 1204 and $0.99 is 99."""
    available_balance_decimal: NotRequired[str]
    r"""The wallet's total available balance after recording a completed transaction. Same as `availableBalance`, but a decimal-formatted numerical string that represents up to 9 decimal place precision. In USD for example, 12.987654321 is $12.987654321 and 0.9987634521 is $0.9987634521."""
    sweep_id: NotRequired[str]


class WalletTransaction(BaseModel):
    r"""A transaction that funds or deducts from the wallet."""

    wallet_id: Annotated[str, pydantic.Field(alias="walletID")]

    transaction_id: Annotated[str, pydantic.Field(alias="transactionID")]

    transaction_type: Annotated[
        WalletTransactionType, pydantic.Field(alias="transactionType")
    ]

    source_type: Annotated[
        WalletTransactionSourceType, pydantic.Field(alias="sourceType")
    ]

    source_id: Annotated[str, pydantic.Field(alias="sourceID")]
    r"""The ID of the Moov object to which this transaction is related."""

    status: WalletTransactionStatus

    memo: str
    r"""Detailed description of the transaction."""

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]

    currency: str
    r"""A 3-letter ISO 4217 currency code."""

    gross_amount: Annotated[int, pydantic.Field(alias="grossAmount")]
    r"""The total transaction amount. The amount is in the smallest unit of the specified currency. In USD this is cents, for example, $12.04 is 1204 and $0.99 is 99."""

    gross_amount_decimal: Annotated[str, pydantic.Field(alias="grossAmountDecimal")]
    r"""The total transaction amount. Same as `grossAmount`, but a decimal-formatted numerical string that represents up to 9 decimal place precision. In USD for example, 12.987654321 is $12.987654321 and 0.9987634521 is $0.9987634521."""

    fee: int
    r"""Total fees paid for the transaction. The value is in the smallest unit of the specified currency. In USD this is cents, for example, $12.04 is 1204 and $0.99 is 99."""

    fee_decimal: Annotated[str, pydantic.Field(alias="feeDecimal")]
    r"""Total fees paid for the transaction. Same as `fee`, but a decimal-formatted numerical string that represents up to 9 decimal place precision. In USD for example, 12.987654321 is $12.987654321 and 0.9987634521 is $0.9987634521."""

    net_amount: Annotated[int, pydantic.Field(alias="netAmount")]
    r"""Net amount is the gross amount less fees paid, and the amount that affects the wallet's balance. The amount is in the smallest unit of the specified currency. In USD this is cents, for example, $12.04 is 1204 and $0.99 is 99."""

    net_amount_decimal: Annotated[str, pydantic.Field(alias="netAmountDecimal")]
    r"""Net amount is the gross amount less fees paid, and the amount that affects the wallet's balance. Same as `netAmount`, but a decimal-formatted numerical string that represents up to 9 decimal place precision. In USD for example, 12.987654321 is $12.987654321 and 0.9987634521 is $0.9987634521."""

    completed_on: Annotated[Optional[datetime], pydantic.Field(alias="completedOn")] = (
        None
    )

    fee_i_ds: Annotated[Optional[List[str]], pydantic.Field(alias="feeIDs")] = None
    r"""The IDs of the fees paid for the transaction."""

    available_balance: Annotated[
        Optional[int], pydantic.Field(alias="availableBalance")
    ] = None
    r"""The wallet's total available balance after recording a completed transaction. The value is in the smallest unit of the specified currency. In USD this is cents, for example, $12.04 is 1204 and $0.99 is 99."""

    available_balance_decimal: Annotated[
        Optional[str], pydantic.Field(alias="availableBalanceDecimal")
    ] = None
    r"""The wallet's total available balance after recording a completed transaction. Same as `availableBalance`, but a decimal-formatted numerical string that represents up to 9 decimal place precision. In USD for example, 12.987654321 is $12.987654321 and 0.9987634521 is $0.9987634521."""

    sweep_id: Annotated[Optional[str], pydantic.Field(alias="sweepID")] = None
