"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .achtransactiondetails import ACHTransactionDetails, ACHTransactionDetailsTypedDict
from .applepayresponse import ApplePayResponse, ApplePayResponseTypedDict
from .cardtransactiondetails import (
    CardTransactionDetails,
    CardTransactionDetailsTypedDict,
)
from .paymentmethodsbankaccount import (
    PaymentMethodsBankAccount,
    PaymentMethodsBankAccountTypedDict,
)
from .paymentmethodscard import PaymentMethodsCard, PaymentMethodsCardTypedDict
from .paymentmethodswallet import PaymentMethodsWallet, PaymentMethodsWalletTypedDict
from .paymentmethodtype import PaymentMethodType
from .terminalcard import TerminalCard, TerminalCardTypedDict
from .transferaccount import TransferAccount, TransferAccountTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TransferSourceTypedDict(TypedDict):
    payment_method_id: str
    payment_method_type: PaymentMethodType
    r"""The payment method type that represents a payment rail and directionality"""
    account: TransferAccountTypedDict
    transfer_id: NotRequired[str]
    r"""UUID present only if the transfer is part of a transfer group."""
    bank_account: NotRequired[PaymentMethodsBankAccountTypedDict]
    r"""A bank account as contained within a payment method."""
    wallet: NotRequired[PaymentMethodsWalletTypedDict]
    card: NotRequired[PaymentMethodsCardTypedDict]
    r"""A card as contained within a payment method."""
    apple_pay: NotRequired[ApplePayResponseTypedDict]
    r"""Describes an Apple Pay token on a Moov account."""
    terminal_card: NotRequired[TerminalCardTypedDict]
    r"""Describes payment card details captured with tap or in-person payment."""
    card_details: NotRequired[CardTransactionDetailsTypedDict]
    r"""Card-specific details about the transaction."""
    ach_details: NotRequired[ACHTransactionDetailsTypedDict]
    r"""ACH specific details about the transaction."""


class TransferSource(BaseModel):
    payment_method_id: Annotated[str, pydantic.Field(alias="paymentMethodID")]

    payment_method_type: Annotated[
        PaymentMethodType, pydantic.Field(alias="paymentMethodType")
    ]
    r"""The payment method type that represents a payment rail and directionality"""

    account: TransferAccount

    transfer_id: Annotated[Optional[str], pydantic.Field(alias="transferID")] = None
    r"""UUID present only if the transfer is part of a transfer group."""

    bank_account: Annotated[
        Optional[PaymentMethodsBankAccount], pydantic.Field(alias="bankAccount")
    ] = None
    r"""A bank account as contained within a payment method."""

    wallet: Optional[PaymentMethodsWallet] = None

    card: Optional[PaymentMethodsCard] = None
    r"""A card as contained within a payment method."""

    apple_pay: Annotated[
        Optional[ApplePayResponse], pydantic.Field(alias="applePay")
    ] = None
    r"""Describes an Apple Pay token on a Moov account."""

    terminal_card: Annotated[
        Optional[TerminalCard], pydantic.Field(alias="terminalCard")
    ] = None
    r"""Describes payment card details captured with tap or in-person payment."""

    card_details: Annotated[
        Optional[CardTransactionDetails], pydantic.Field(alias="cardDetails")
    ] = None
    r"""Card-specific details about the transaction."""

    ach_details: Annotated[
        Optional[ACHTransactionDetails], pydantic.Field(alias="achDetails")
    ] = None
    r"""ACH specific details about the transaction."""
