"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .sweepconfigpaymentmethod import (
    SweepConfigPaymentMethod,
    SweepConfigPaymentMethodTypedDict,
)
from .sweepconfigstatus import SweepConfigStatus
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SweepConfigTypedDict(TypedDict):
    sweep_config_id: str
    wallet_id: str
    status: SweepConfigStatus
    push_payment_method: SweepConfigPaymentMethodTypedDict
    r"""The payment method used to push or pull funds to a bank account.
    The push payment method can only be ach-credit-standard or ach-credit-same-day. The pull payment method can only be ach-debit-fund.
    """
    pull_payment_method: SweepConfigPaymentMethodTypedDict
    r"""The payment method used to push or pull funds to a bank account.
    The push payment method can only be ach-credit-standard or ach-credit-same-day. The pull payment method can only be ach-debit-fund.
    """
    created_on: datetime
    updated_on: datetime
    minimum_balance: NotRequired[str]
    r"""An optional field to specify an amount to maintain in the wallet. This is a decimal-formatted numerical string that represents up to 2 decimal place precision. In USD for example, 12.34 is $12.34 and 0.99 is $0.99. If not supplied, the default is 0.00."""
    statement_descriptor: NotRequired[str]
    r"""The text that appears on the banking statement. The default descriptor is a 10 character ID if an override is not set in the sweep configs statementDescriptor."""
    locked_fields: NotRequired[List[str]]
    r"""An array of fields that are locked. To request updates, please contact Moov support."""


class SweepConfig(BaseModel):
    sweep_config_id: Annotated[str, pydantic.Field(alias="sweepConfigID")]

    wallet_id: Annotated[str, pydantic.Field(alias="walletID")]

    status: SweepConfigStatus

    push_payment_method: Annotated[
        SweepConfigPaymentMethod, pydantic.Field(alias="pushPaymentMethod")
    ]
    r"""The payment method used to push or pull funds to a bank account.
    The push payment method can only be ach-credit-standard or ach-credit-same-day. The pull payment method can only be ach-debit-fund.
    """

    pull_payment_method: Annotated[
        SweepConfigPaymentMethod, pydantic.Field(alias="pullPaymentMethod")
    ]
    r"""The payment method used to push or pull funds to a bank account.
    The push payment method can only be ach-credit-standard or ach-credit-same-day. The pull payment method can only be ach-debit-fund.
    """

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]

    updated_on: Annotated[datetime, pydantic.Field(alias="updatedOn")]

    minimum_balance: Annotated[
        Optional[str], pydantic.Field(alias="minimumBalance")
    ] = None
    r"""An optional field to specify an amount to maintain in the wallet. This is a decimal-formatted numerical string that represents up to 2 decimal place precision. In USD for example, 12.34 is $12.34 and 0.99 is $0.99. If not supplied, the default is 0.00."""

    statement_descriptor: Annotated[
        Optional[str], pydantic.Field(alias="statementDescriptor")
    ] = None
    r"""The text that appears on the banking statement. The default descriptor is a 10 character ID if an override is not set in the sweep configs statementDescriptor."""

    locked_fields: Annotated[
        Optional[List[str]], pydantic.Field(alias="lockedFields")
    ] = None
    r"""An array of fields that are locked. To request updates, please contact Moov support."""
