"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .sweepstatus import SweepStatus
from .sweepsubtotal import SweepSubtotal, SweepSubtotalTypedDict
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SweepTypedDict(TypedDict):
    sweep_id: str
    status: SweepStatus
    accrued_amount: str
    r"""The total net amount of wallet transactions accrued in the sweep."""
    currency: str
    r"""A 3-letter ISO 4217 currency code."""
    accrual_started_on: datetime
    r"""The date-time the sweep began accruing transactions."""
    residual_balance: NotRequired[str]
    r"""Amount remaining in the wallet after the sweep transfer completes."""
    accrual_ended_on: NotRequired[datetime]
    r"""The date-time the sweep stopped accruing transactions."""
    push_payment_method_id: NotRequired[str]
    r"""ID of the payment method."""
    pull_payment_method_id: NotRequired[str]
    r"""ID of the payment method."""
    transfer_id: NotRequired[str]
    transfer_amount: NotRequired[str]
    r"""Amount that is transferred."""
    statement_descriptor: NotRequired[str]
    r"""The text that appears on the banking statement. The default descriptor is a 10 character ID if an override is not set in the sweep configs statementDescriptor."""
    subtotals: NotRequired[List[SweepSubtotalTypedDict]]
    r"""The subtotal of each transaction type contributing to the sweep's accrued amount."""


class Sweep(BaseModel):
    sweep_id: Annotated[str, pydantic.Field(alias="sweepID")]

    status: SweepStatus

    accrued_amount: Annotated[str, pydantic.Field(alias="accruedAmount")]
    r"""The total net amount of wallet transactions accrued in the sweep."""

    currency: str
    r"""A 3-letter ISO 4217 currency code."""

    accrual_started_on: Annotated[datetime, pydantic.Field(alias="accrualStartedOn")]
    r"""The date-time the sweep began accruing transactions."""

    residual_balance: Annotated[
        Optional[str], pydantic.Field(alias="residualBalance")
    ] = None
    r"""Amount remaining in the wallet after the sweep transfer completes."""

    accrual_ended_on: Annotated[
        Optional[datetime], pydantic.Field(alias="accrualEndedOn")
    ] = None
    r"""The date-time the sweep stopped accruing transactions."""

    push_payment_method_id: Annotated[
        Optional[str], pydantic.Field(alias="pushPaymentMethodID")
    ] = None
    r"""ID of the payment method."""

    pull_payment_method_id: Annotated[
        Optional[str], pydantic.Field(alias="pullPaymentMethodID")
    ] = None
    r"""ID of the payment method."""

    transfer_id: Annotated[Optional[str], pydantic.Field(alias="transferID")] = None

    transfer_amount: Annotated[
        Optional[str], pydantic.Field(alias="transferAmount")
    ] = None
    r"""Amount that is transferred."""

    statement_descriptor: Annotated[
        Optional[str], pydantic.Field(alias="statementDescriptor")
    ] = None
    r"""The text that appears on the banking statement. The default descriptor is a 10 character ID if an override is not set in the sweep configs statementDescriptor."""

    subtotals: Optional[List[SweepSubtotal]] = None
    r"""The subtotal of each transaction type contributing to the sweep's accrued amount."""
