"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class AchDetailsTypedDict(TypedDict):
    company_entry_description: NotRequired[str]
    r"""An optional override of the default NACHA company entry description for a transfer."""
    originating_company_name: NotRequired[str]
    r"""An optional override of the default NACHA company name for a transfer."""


class AchDetails(BaseModel):
    company_entry_description: Annotated[
        Optional[str], pydantic.Field(alias="companyEntryDescription")
    ] = None
    r"""An optional override of the default NACHA company entry description for a transfer."""

    originating_company_name: Annotated[
        Optional[str], pydantic.Field(alias="originatingCompanyName")
    ] = None
    r"""An optional override of the default NACHA company name for a transfer."""


class CardDetailsTypedDict(TypedDict):
    dynamic_descriptor: NotRequired[str]
    r"""An optional override of the default card statement descriptor for a transfer. Accounts must be enabled by Moov to set this field."""


class CardDetails(BaseModel):
    dynamic_descriptor: Annotated[
        Optional[str], pydantic.Field(alias="dynamicDescriptor")
    ] = None
    r"""An optional override of the default card statement descriptor for a transfer. Accounts must be enabled by Moov to set this field."""


class SchedulePaymentMethodTypedDict(TypedDict):
    payment_method_id: str
    ach_details: NotRequired[AchDetailsTypedDict]
    card_details: NotRequired[CardDetailsTypedDict]


class SchedulePaymentMethod(BaseModel):
    payment_method_id: Annotated[str, pydantic.Field(alias="paymentMethodID")]

    ach_details: Annotated[Optional[AchDetails], pydantic.Field(alias="achDetails")] = (
        None
    )

    card_details: Annotated[
        Optional[CardDetails], pydantic.Field(alias="cardDetails")
    ] = None
