"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .cardexpiration import CardExpiration, CardExpirationTypedDict
from .createauthorizeduser import CreateAuthorizedUser, CreateAuthorizedUserTypedDict
from .issuedcardformfactor import IssuedCardFormFactor
from .issuingcontrols import IssuingControls, IssuingControlsTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class RequestCardTypedDict(TypedDict):
    funding_wallet_id: str
    authorized_user: CreateAuthorizedUserTypedDict
    r"""Fields for identifying an authorized individual."""
    form_factor: IssuedCardFormFactor
    r"""Specifies the type of spend card to be issued. Presently supports virtual only, providing a digital number without a physical card."""
    memo: NotRequired[str]
    r"""An optional descriptive name for the card."""
    expiration: NotRequired[CardExpirationTypedDict]
    r"""The expiration date of the card or token."""
    controls: NotRequired[IssuingControlsTypedDict]


class RequestCard(BaseModel):
    funding_wallet_id: Annotated[str, pydantic.Field(alias="fundingWalletID")]

    authorized_user: Annotated[
        CreateAuthorizedUser, pydantic.Field(alias="authorizedUser")
    ]
    r"""Fields for identifying an authorized individual."""

    form_factor: Annotated[IssuedCardFormFactor, pydantic.Field(alias="formFactor")]
    r"""Specifies the type of spend card to be issued. Presently supports virtual only, providing a digital number without a physical card."""

    memo: Optional[str] = None
    r"""An optional descriptive name for the card."""

    expiration: Optional[CardExpiration] = None
    r"""The expiration date of the card or token."""

    controls: Optional[IssuingControls] = None
