"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .receiptkind import ReceiptKind
from .sentreceipt import SentReceipt, SentReceiptTypedDict
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ReceiptResponseTypedDict(TypedDict):
    receipt_id: str
    r"""Unique identifier for the receipt request."""
    created_by: str
    r"""AccountID for which the receipt request was created."""
    kind: ReceiptKind
    r"""The type of receipt."""
    disabled_on: NotRequired[datetime]
    r"""The date and time the receipt was disabled."""
    email: NotRequired[str]
    r"""The email address the receipt is sent to.
    Either email or emailAccountID will be in the response, but not both.
    """
    email_account_id: NotRequired[str]
    r"""The accountID the receipt is sent to.
    Either email or emailAccountID will be in the response, but not both.
    """
    for_transfer_id: NotRequired[str]
    r"""The ID of the transfer associated with this receipt.
    Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
    """
    for_schedule_id: NotRequired[str]
    r"""The ID of the schedule associated with this receipt.
    Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
    """
    for_occurrence_id: NotRequired[str]
    r"""The ID of the schedule occurrence associated with this receipt.
    Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
    """
    sent_for: NotRequired[List[SentReceiptTypedDict]]
    r"""The list of receipts that have been sent."""


class ReceiptResponse(BaseModel):
    receipt_id: Annotated[str, pydantic.Field(alias="receiptID")]
    r"""Unique identifier for the receipt request."""

    created_by: Annotated[str, pydantic.Field(alias="createdBy")]
    r"""AccountID for which the receipt request was created."""

    kind: ReceiptKind
    r"""The type of receipt."""

    disabled_on: Annotated[Optional[datetime], pydantic.Field(alias="disabledOn")] = (
        None
    )
    r"""The date and time the receipt was disabled."""

    email: Optional[str] = None
    r"""The email address the receipt is sent to.
    Either email or emailAccountID will be in the response, but not both.
    """

    email_account_id: Annotated[
        Optional[str], pydantic.Field(alias="emailAccountID")
    ] = None
    r"""The accountID the receipt is sent to.
    Either email or emailAccountID will be in the response, but not both.
    """

    for_transfer_id: Annotated[Optional[str], pydantic.Field(alias="forTransferID")] = (
        None
    )
    r"""The ID of the transfer associated with this receipt.
    Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
    """

    for_schedule_id: Annotated[Optional[str], pydantic.Field(alias="forScheduleID")] = (
        None
    )
    r"""The ID of the schedule associated with this receipt.
    Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
    """

    for_occurrence_id: Annotated[
        Optional[str], pydantic.Field(alias="forOccurrenceID")
    ] = None
    r"""The ID of the schedule occurrence associated with this receipt.
    Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
    """

    sent_for: Annotated[
        Optional[List[SentReceipt]], pydantic.Field(alias="sentFor")
    ] = None
    r"""The list of receipts that have been sent."""
