"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .receiptkind import ReceiptKind
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ReceiptRequestTypedDict(TypedDict):
    r"""A receipt request for a specific transfer, schedule, or schedule occurrence."""

    kind: ReceiptKind
    r"""The type of receipt being requested."""
    email: NotRequired[str]
    r"""The email address to send the receipt to.
    Either email or emailAccountID must be provided, but not both.
    """
    email_account_id: NotRequired[str]
    r"""The accountID to send the receipt to.
    Either email or emailAccountID must be provided, but not both.
    """
    for_transfer_id: NotRequired[str]
    r"""The ID of the transfer associated with this receipt.
    Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
    """
    for_schedule_id: NotRequired[str]
    r"""The ID of the schedule associated with this receipt.
    Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
    """
    for_occurrence_id: NotRequired[str]
    r"""The ID of the schedule occurrence associated with this receipt.
    Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
    """


class ReceiptRequest(BaseModel):
    r"""A receipt request for a specific transfer, schedule, or schedule occurrence."""

    kind: ReceiptKind
    r"""The type of receipt being requested."""

    email: Optional[str] = None
    r"""The email address to send the receipt to.
    Either email or emailAccountID must be provided, but not both.
    """

    email_account_id: Annotated[
        Optional[str], pydantic.Field(alias="emailAccountID")
    ] = None
    r"""The accountID to send the receipt to.
    Either email or emailAccountID must be provided, but not both.
    """

    for_transfer_id: Annotated[Optional[str], pydantic.Field(alias="forTransferID")] = (
        None
    )
    r"""The ID of the transfer associated with this receipt.
    Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
    """

    for_schedule_id: Annotated[Optional[str], pydantic.Field(alias="forScheduleID")] = (
        None
    )
    r"""The ID of the schedule associated with this receipt.
    Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
    """

    for_occurrence_id: Annotated[
        Optional[str], pydantic.Field(alias="forOccurrenceID")
    ] = None
    r"""The ID of the schedule occurrence associated with this receipt.
    Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
    """
