"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .businessprofile import BusinessProfile, BusinessProfileTypedDict
from .guestprofile import GuestProfile, GuestProfileTypedDict
from .individualprofile import IndividualProfile, IndividualProfileTypedDict
from moovio_sdk.types import BaseModel
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class ProfileTypedDict(TypedDict):
    r"""Describes a Moov account profile. A profile will have a business or an individual, depending on the account's type."""

    individual: NotRequired[IndividualProfileTypedDict]
    r"""Describes an individual."""
    business: NotRequired[BusinessProfileTypedDict]
    r"""Describes a business."""
    guest: NotRequired[GuestProfileTypedDict]
    r"""Describes a guest account profile."""


class Profile(BaseModel):
    r"""Describes a Moov account profile. A profile will have a business or an individual, depending on the account's type."""

    individual: Optional[IndividualProfile] = None
    r"""Describes an individual."""

    business: Optional[BusinessProfile] = None
    r"""Describes a business."""

    guest: Optional[GuestProfile] = None
    r"""Describes a guest account profile."""
