"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from moovio_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class Status(str, Enum):
    ENABLED = "enabled"
    DISABLED = "disabled"


class PushPaymentMethodID2TypedDict(TypedDict):
    pass


class PushPaymentMethodID2(BaseModel):
    pass


PushPaymentMethodIDTypedDict = TypeAliasType(
    "PushPaymentMethodIDTypedDict", Union[PushPaymentMethodID2TypedDict, str]
)


PushPaymentMethodID = TypeAliasType(
    "PushPaymentMethodID", Union[PushPaymentMethodID2, str]
)


class PullPaymentMethodID2TypedDict(TypedDict):
    pass


class PullPaymentMethodID2(BaseModel):
    pass


PullPaymentMethodIDTypedDict = TypeAliasType(
    "PullPaymentMethodIDTypedDict", Union[PullPaymentMethodID2TypedDict, str]
)


PullPaymentMethodID = TypeAliasType(
    "PullPaymentMethodID", Union[PullPaymentMethodID2, str]
)


class StatementDescriptor2TypedDict(TypedDict):
    pass


class StatementDescriptor2(BaseModel):
    pass


StatementDescriptorTypedDict = TypeAliasType(
    "StatementDescriptorTypedDict", Union[StatementDescriptor2TypedDict, str]
)


StatementDescriptor = TypeAliasType(
    "StatementDescriptor", Union[StatementDescriptor2, str]
)


class PatchSweepConfigTypedDict(TypedDict):
    status: NotRequired[Nullable[Status]]
    push_payment_method_id: NotRequired[Nullable[PushPaymentMethodIDTypedDict]]
    pull_payment_method_id: NotRequired[Nullable[PullPaymentMethodIDTypedDict]]
    statement_descriptor: NotRequired[Nullable[StatementDescriptorTypedDict]]
    minimum_balance: NotRequired[Nullable[str]]


class PatchSweepConfig(BaseModel):
    status: OptionalNullable[Status] = UNSET

    push_payment_method_id: Annotated[
        OptionalNullable[PushPaymentMethodID],
        pydantic.Field(alias="pushPaymentMethodID"),
    ] = UNSET

    pull_payment_method_id: Annotated[
        OptionalNullable[PullPaymentMethodID],
        pydantic.Field(alias="pullPaymentMethodID"),
    ] = UNSET

    statement_descriptor: Annotated[
        OptionalNullable[StatementDescriptor],
        pydantic.Field(alias="statementDescriptor"),
    ] = UNSET

    minimum_balance: Annotated[
        OptionalNullable[str], pydantic.Field(alias="minimumBalance")
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "status",
            "pushPaymentMethodID",
            "pullPaymentMethodID",
            "statementDescriptor",
            "minimumBalance",
        ]
        nullable_fields = [
            "status",
            "pushPaymentMethodID",
            "pullPaymentMethodID",
            "statementDescriptor",
            "minimumBalance",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
