"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .addressupdate import AddressUpdate, AddressUpdateTypedDict
from .createaccountsettings import CreateAccountSettings, CreateAccountSettingsTypedDict
from .manualtermsofserviceupdate import (
    ManualTermsOfServiceUpdate,
    ManualTermsOfServiceUpdateTypedDict,
)
from .patchprofile import PatchProfile, PatchProfileTypedDict
from .phonenumber import PhoneNumber, PhoneNumberTypedDict
from .termsofservicetokenupdate import (
    TermsOfServiceTokenUpdate,
    TermsOfServiceTokenUpdateTypedDict,
)
from moovio_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Dict, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


PatchAccountTermsOfServiceTypedDict = TypeAliasType(
    "PatchAccountTermsOfServiceTypedDict",
    Union[TermsOfServiceTokenUpdateTypedDict, ManualTermsOfServiceUpdateTypedDict],
)


PatchAccountTermsOfService = TypeAliasType(
    "PatchAccountTermsOfService",
    Union[TermsOfServiceTokenUpdate, ManualTermsOfServiceUpdate],
)


class PatchAccountCustomerSupportTypedDict(TypedDict):
    r"""User-provided information that can be displayed on credit card transactions for customers to use when
    contacting a customer support team. This data is only allowed on a business account.
    """

    phone: NotRequired[PhoneNumberTypedDict]
    email: NotRequired[str]
    address: NotRequired[AddressUpdateTypedDict]
    website: NotRequired[str]


class PatchAccountCustomerSupport(BaseModel):
    r"""User-provided information that can be displayed on credit card transactions for customers to use when
    contacting a customer support team. This data is only allowed on a business account.
    """

    phone: Optional[PhoneNumber] = None

    email: Optional[str] = None

    address: Optional[AddressUpdate] = None

    website: Optional[str] = None


class PatchAccountTypedDict(TypedDict):
    r"""Describes the fields available when patching a Moov account."""

    profile: NotRequired[PatchProfileTypedDict]
    r"""Describes the fields available when patching a profile.
    Each object can be patched independent of patching the other fields.
    """
    metadata: NotRequired[Nullable[Dict[str, str]]]
    terms_of_service: NotRequired[PatchAccountTermsOfServiceTypedDict]
    foreign_id: NotRequired[str]
    customer_support: NotRequired[Nullable[PatchAccountCustomerSupportTypedDict]]
    settings: NotRequired[CreateAccountSettingsTypedDict]


class PatchAccount(BaseModel):
    r"""Describes the fields available when patching a Moov account."""

    profile: Optional[PatchProfile] = None
    r"""Describes the fields available when patching a profile.
    Each object can be patched independent of patching the other fields.
    """

    metadata: OptionalNullable[Dict[str, str]] = UNSET

    terms_of_service: Annotated[
        Optional[PatchAccountTermsOfService], pydantic.Field(alias="termsOfService")
    ] = None

    foreign_id: Annotated[Optional[str], pydantic.Field(alias="foreignID")] = None

    customer_support: Annotated[
        OptionalNullable[PatchAccountCustomerSupport],
        pydantic.Field(alias="customerSupport"),
    ] = UNSET

    settings: Optional[CreateAccountSettings] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "profile",
            "metadata",
            "termsOfService",
            "foreignID",
            "customerSupport",
            "settings",
        ]
        nullable_fields = ["metadata", "customerSupport"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
