"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .mode import Mode
from .occurrencestatus import OccurrenceStatus
from .runtransfer import RunTransfer, RunTransferTypedDict
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ErrorTypedDict(TypedDict):
    r"""Contains details on why the occurrence errored."""

    message: NotRequired[str]


class Error(BaseModel):
    r"""Contains details on why the occurrence errored."""

    message: Optional[str] = None


class OccurrencesResponseTypedDict(TypedDict):
    run_on: datetime
    run_transfer: RunTransferTypedDict
    r"""Defines the attributes of a transfer."""
    schedule_id: NotRequired[str]
    occurrence_id: NotRequired[str]
    mode: NotRequired[Mode]
    r"""Sandbox or production account mode of this schedule."""
    generated: NotRequired[bool]
    r"""True if this was generated by a RRule."""
    indefinite: NotRequired[bool]
    r"""True if the RRule set runs indefinitely."""
    canceled_on: NotRequired[datetime]
    ran_on: NotRequired[datetime]
    ran_transfer_id: NotRequired[str]
    status: NotRequired[OccurrenceStatus]
    r"""Status of the completed occurrence."""
    error: NotRequired[ErrorTypedDict]
    r"""Contains details on why the occurrence errored."""


class OccurrencesResponse(BaseModel):
    run_on: Annotated[datetime, pydantic.Field(alias="runOn")]

    run_transfer: Annotated[RunTransfer, pydantic.Field(alias="runTransfer")]
    r"""Defines the attributes of a transfer."""

    schedule_id: Annotated[Optional[str], pydantic.Field(alias="scheduleID")] = None

    occurrence_id: Annotated[Optional[str], pydantic.Field(alias="occurrenceID")] = None

    mode: Optional[Mode] = None
    r"""Sandbox or production account mode of this schedule."""

    generated: Optional[bool] = None
    r"""True if this was generated by a RRule."""

    indefinite: Optional[bool] = None
    r"""True if the RRule set runs indefinitely."""

    canceled_on: Annotated[Optional[datetime], pydantic.Field(alias="canceledOn")] = (
        None
    )

    ran_on: Annotated[Optional[datetime], pydantic.Field(alias="ranOn")] = None

    ran_transfer_id: Annotated[Optional[str], pydantic.Field(alias="ranTransferID")] = (
        None
    )

    status: Optional[OccurrenceStatus] = None
    r"""Status of the completed occurrence."""

    error: Optional[Error] = None
    r"""Contains details on why the occurrence errored."""
