"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class MoovFeeDetailsTypedDict(TypedDict):
    r"""Processing and pass-through costs that add up to the moovFee."""

    moov_processing: str
    r"""Moov processing fee. String type represents dollars with up to 9 decimal place precision."""
    card_scheme: NotRequired[str]
    r"""Card scheme fees accrued during authorization and settlement. String type represents dollars with up to 9 decimal place precision."""
    interchange: NotRequired[str]
    r"""Network interchange fee for Visa, Mastercard, or Discover. String type represents dollars with up to 9 decimal place precision."""
    discount: NotRequired[str]
    r"""Network discount fee for American Express. String type represents dollars with up to 9 decimal place precision."""


class MoovFeeDetails(BaseModel):
    r"""Processing and pass-through costs that add up to the moovFee."""

    moov_processing: Annotated[str, pydantic.Field(alias="moovProcessing")]
    r"""Moov processing fee. String type represents dollars with up to 9 decimal place precision."""

    card_scheme: Annotated[Optional[str], pydantic.Field(alias="cardScheme")] = None
    r"""Card scheme fees accrued during authorization and settlement. String type represents dollars with up to 9 decimal place precision."""

    interchange: Optional[str] = None
    r"""Network interchange fee for Visa, Mastercard, or Discover. String type represents dollars with up to 9 decimal place precision."""

    discount: Optional[str] = None
    r"""Network discount fee for American Express. String type represents dollars with up to 9 decimal place precision."""
