"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .address import Address, AddressTypedDict
from .individualname import IndividualName, IndividualNameTypedDict
from .phonenumber import PhoneNumber, PhoneNumberTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class IndividualProfileTypedDict(TypedDict):
    r"""Describes an individual."""

    name: IndividualNameTypedDict
    phone: NotRequired[PhoneNumberTypedDict]
    email: NotRequired[str]
    address: NotRequired[AddressTypedDict]
    birth_date_provided: NotRequired[bool]
    r"""Indicates whether this individual's birth date has been provided."""
    government_id_provided: NotRequired[bool]
    r"""Indicates whether a government ID (SSN, ITIN, etc.) has been provided for this individual."""


class IndividualProfile(BaseModel):
    r"""Describes an individual."""

    name: IndividualName

    phone: Optional[PhoneNumber] = None

    email: Optional[str] = None

    address: Optional[Address] = None

    birth_date_provided: Annotated[
        Optional[bool], pydantic.Field(alias="birthDateProvided")
    ] = None
    r"""Indicates whether this individual's birth date has been provided."""

    government_id_provided: Annotated[
        Optional[bool], pydantic.Field(alias="governmentIDProvided")
    ] = None
    r"""Indicates whether a government ID (SSN, ITIN, etc.) has been provided for this individual."""
