"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class FacilitatorFeeTypedDict(TypedDict):
    r"""Total or markup fee."""

    total: NotRequired[int]
    r"""Total facilitator fee in cents. Only either `total` or `totalDecimal` can be set."""
    total_decimal: NotRequired[str]
    r"""Same as `total`, but a decimal-formatted numerical string that represents up to 9 decimal place precision.

    Only either `total` or `totalDecimal` can be set. Set this field if you expect the fee to be in fractions of a cent.
    """
    markup: NotRequired[int]
    r"""Markup facilitator fee in cents. Only either `markup` or `markupDecimal` can be set."""
    markup_decimal: NotRequired[str]
    r"""Same as `markup`, but a decimal-formatted numerical string that represents up to 9 decimal place precision.
    Only either `markup` or `markupDecimal` can be set. Set this field if you expect the fee to be in fractions of a cent.
    """


class FacilitatorFee(BaseModel):
    r"""Total or markup fee."""

    total: Optional[int] = None
    r"""Total facilitator fee in cents. Only either `total` or `totalDecimal` can be set."""

    total_decimal: Annotated[Optional[str], pydantic.Field(alias="totalDecimal")] = None
    r"""Same as `total`, but a decimal-formatted numerical string that represents up to 9 decimal place precision.

    Only either `total` or `totalDecimal` can be set. Set this field if you expect the fee to be in fractions of a cent.
    """

    markup: Optional[int] = None
    r"""Markup facilitator fee in cents. Only either `markup` or `markupDecimal` can be set."""

    markup_decimal: Annotated[Optional[str], pydantic.Field(alias="markupDecimal")] = (
        None
    )
    r"""Same as `markup`, but a decimal-formatted numerical string that represents up to 9 decimal place precision.
    Only either `markup` or `markupDecimal` can be set. Set this field if you expect the fee to be in fractions of a cent.
    """
