"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .disputephase import DisputePhase
from .disputestatus import DisputeStatus
from .disputetransferdetails import (
    DisputeTransferDetails,
    DisputeTransferDetailsTypedDict,
)
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class DisputeTypedDict(TypedDict):
    r"""Details of a card transaction dispute."""

    dispute_id: str
    merchant_account_id: str
    amount: AmountTypedDict
    network_reason_code: str
    r"""Indicates the card network's category for the dispute.

    These codes may differ between card brands. You can find more information on the code from the networkReasonDescription field.
    """
    transfer: DisputeTransferDetailsTypedDict
    respond_by: datetime
    status: DisputeStatus
    r"""The status of a particular dispute.

    Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/#dispute-statuses) to learn what each status means.
    """
    phase: DisputePhase
    r"""The phase of a dispute within the dispute lifecycle."""
    created_on: datetime
    network_reason_description: NotRequired[str]
    r"""Provides detail on the card network's categorization of the dispute."""
    submitted_on: NotRequired[datetime]


class Dispute(BaseModel):
    r"""Details of a card transaction dispute."""

    dispute_id: Annotated[str, pydantic.Field(alias="disputeID")]

    merchant_account_id: Annotated[str, pydantic.Field(alias="merchantAccountID")]

    amount: Amount

    network_reason_code: Annotated[str, pydantic.Field(alias="networkReasonCode")]
    r"""Indicates the card network's category for the dispute.

    These codes may differ between card brands. You can find more information on the code from the networkReasonDescription field.
    """

    transfer: DisputeTransferDetails

    respond_by: Annotated[datetime, pydantic.Field(alias="respondBy")]

    status: DisputeStatus
    r"""The status of a particular dispute.

    Read our [disputes guide](https://docs.moov.io/guides/money-movement/accept-payments/card-acceptance/disputes/#dispute-statuses) to learn what each status means.
    """

    phase: DisputePhase
    r"""The phase of a dispute within the dispute lifecycle."""

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]

    network_reason_description: Annotated[
        Optional[str], pydantic.Field(alias="networkReasonDescription")
    ] = None
    r"""Provides detail on the card network's categorization of the dispute."""

    submitted_on: Annotated[Optional[datetime], pydantic.Field(alias="submittedOn")] = (
        None
    )
