"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .refundcarddetails import RefundCardDetails, RefundCardDetailsTypedDict
from .refundstatus import RefundStatus
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CardAcquiringRefundTypedDict(TypedDict):
    r"""Details of a card refund."""

    refund_id: str
    r"""Identifier for the refund."""
    created_on: datetime
    updated_on: datetime
    status: RefundStatus
    amount: AmountTypedDict
    card_details: NotRequired[RefundCardDetailsTypedDict]


class CardAcquiringRefund(BaseModel):
    r"""Details of a card refund."""

    refund_id: Annotated[str, pydantic.Field(alias="refundID")]
    r"""Identifier for the refund."""

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]

    updated_on: Annotated[datetime, pydantic.Field(alias="updatedOn")]

    status: RefundStatus

    amount: Amount

    card_details: Annotated[
        Optional[RefundCardDetails], pydantic.Field(alias="cardDetails")
    ] = None
