"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .basicpaymentmethod import BasicPaymentMethod, BasicPaymentMethodTypedDict
from .cardaccountupdater import CardAccountUpdater, CardAccountUpdaterTypedDict
from .cardaddress import CardAddress, CardAddressTypedDict
from .cardbrand import CardBrand
from .cardexpiration import CardExpiration, CardExpirationTypedDict
from .cardtype import CardType
from .cardverification import CardVerification, CardVerificationTypedDict
from .domesticpullfromcard import DomesticPullFromCard
from .domesticpushtocard import DomesticPushToCard
from moovio_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CardTypedDict(TypedDict):
    r"""Describes a card on a Moov account."""

    card_id: str
    r"""ID of the card."""
    fingerprint: str
    r"""Uniquely identifies a linked payment card or token.
    For Apple Pay, the fingerprint is based on the tokenized card number and may vary based on the user's device.
    This field can be used to identify specific payment methods across multiple accounts on your platform.
    """
    brand: CardBrand
    r"""The card brand."""
    card_type: CardType
    r"""The type of the card."""
    last_four_card_number: str
    r"""Last four digits of the card number"""
    bin: str
    r"""The first six to eight digits of the card number, which identifies the financial institution that issued the card."""
    expiration: CardExpirationTypedDict
    r"""The expiration date of the card or token."""
    billing_address: CardAddressTypedDict
    card_verification: CardVerificationTypedDict
    r"""The results of submitting cardholder data to a card network for verification."""
    card_category: NotRequired[str]
    r"""The category or level of the card defined by the issuer.
    Examples include, but not limited to, \"REWARDS\", \"TRADITIONAL REWARDS\", \"CLASSIC\", and \"CORPORATE PURCHASING\".
    """
    holder_name: NotRequired[str]
    r"""The name of the cardholder as it appears on the card."""
    issuer: NotRequired[str]
    r"""Financial institution that issued the card."""
    issuer_country: NotRequired[str]
    r"""Country where the card was issued."""
    issuer_url: NotRequired[str]
    r"""URL of the issuer."""
    issuer_phone: NotRequired[str]
    r"""Phone number of the issuer."""
    commercial: NotRequired[bool]
    r"""If true, the card is for commercial use, or associated with a business.
    If false, the card is associated with a general consumer.
    """
    regulated: NotRequired[bool]
    r"""If true, the card issuing bank is regulated, and the scheme fees for debit transactions will be limited based on the Durbin Amendment.
    If false, the card issuing bank is not regulated, and the scheme fees will not be limited.
    """
    card_on_file: NotRequired[bool]
    r"""Indicates cardholder has authorized card to be stored for future payments."""
    merchant_account_id: NotRequired[str]
    card_account_updater: NotRequired[CardAccountUpdaterTypedDict]
    r"""The results of the most recent card update request."""
    domestic_push_to_card: NotRequired[DomesticPushToCard]
    r"""Indicates which level of domestic push-to-card transfer is supported by the card, if any."""
    domestic_pull_from_card: NotRequired[DomesticPullFromCard]
    r"""Indicates if the card supports domestic pull-from-card transfer."""
    payment_methods: NotRequired[List[BasicPaymentMethodTypedDict]]
    r"""Includes any payment methods created as a result of linking a card with the `x-wait-for` header set to `payment-method`.

    Only returned by the link card endpoint; not included when getting or listing cards.
    """


class Card(BaseModel):
    r"""Describes a card on a Moov account."""

    card_id: Annotated[str, pydantic.Field(alias="cardID")]
    r"""ID of the card."""

    fingerprint: str
    r"""Uniquely identifies a linked payment card or token.
    For Apple Pay, the fingerprint is based on the tokenized card number and may vary based on the user's device.
    This field can be used to identify specific payment methods across multiple accounts on your platform.
    """

    brand: CardBrand
    r"""The card brand."""

    card_type: Annotated[CardType, pydantic.Field(alias="cardType")]
    r"""The type of the card."""

    last_four_card_number: Annotated[str, pydantic.Field(alias="lastFourCardNumber")]
    r"""Last four digits of the card number"""

    bin: str
    r"""The first six to eight digits of the card number, which identifies the financial institution that issued the card."""

    expiration: CardExpiration
    r"""The expiration date of the card or token."""

    billing_address: Annotated[CardAddress, pydantic.Field(alias="billingAddress")]

    card_verification: Annotated[
        CardVerification, pydantic.Field(alias="cardVerification")
    ]
    r"""The results of submitting cardholder data to a card network for verification."""

    card_category: Annotated[Optional[str], pydantic.Field(alias="cardCategory")] = None
    r"""The category or level of the card defined by the issuer.
    Examples include, but not limited to, \"REWARDS\", \"TRADITIONAL REWARDS\", \"CLASSIC\", and \"CORPORATE PURCHASING\".
    """

    holder_name: Annotated[Optional[str], pydantic.Field(alias="holderName")] = None
    r"""The name of the cardholder as it appears on the card."""

    issuer: Optional[str] = None
    r"""Financial institution that issued the card."""

    issuer_country: Annotated[Optional[str], pydantic.Field(alias="issuerCountry")] = (
        None
    )
    r"""Country where the card was issued."""

    issuer_url: Annotated[Optional[str], pydantic.Field(alias="issuerURL")] = None
    r"""URL of the issuer."""

    issuer_phone: Annotated[Optional[str], pydantic.Field(alias="issuerPhone")] = None
    r"""Phone number of the issuer."""

    commercial: Optional[bool] = None
    r"""If true, the card is for commercial use, or associated with a business.
    If false, the card is associated with a general consumer.
    """

    regulated: Optional[bool] = None
    r"""If true, the card issuing bank is regulated, and the scheme fees for debit transactions will be limited based on the Durbin Amendment.
    If false, the card issuing bank is not regulated, and the scheme fees will not be limited.
    """

    card_on_file: Annotated[Optional[bool], pydantic.Field(alias="cardOnFile")] = None
    r"""Indicates cardholder has authorized card to be stored for future payments."""

    merchant_account_id: Annotated[
        Optional[str], pydantic.Field(alias="merchantAccountID")
    ] = None

    card_account_updater: Annotated[
        Optional[CardAccountUpdater], pydantic.Field(alias="cardAccountUpdater")
    ] = None
    r"""The results of the most recent card update request."""

    domestic_push_to_card: Annotated[
        Optional[DomesticPushToCard], pydantic.Field(alias="domesticPushToCard")
    ] = None
    r"""Indicates which level of domestic push-to-card transfer is supported by the card, if any."""

    domestic_pull_from_card: Annotated[
        Optional[DomesticPullFromCard], pydantic.Field(alias="domesticPullFromCard")
    ] = None
    r"""Indicates if the card supports domestic pull-from-card transfer."""

    payment_methods: Annotated[
        Optional[List[BasicPaymentMethod]], pydantic.Field(alias="paymentMethods")
    ] = None
    r"""Includes any payment methods created as a result of linking a card with the `x-wait-for` header set to `payment-method`.

    Only returned by the link card endpoint; not included when getting or listing cards.
    """
