"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .capabilityid import CapabilityID
from .capabilityrequirement import CapabilityRequirement, CapabilityRequirementTypedDict
from .capabilitystatus import CapabilityStatus
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CapabilityTypedDict(TypedDict):
    capability: CapabilityID
    r"""Moov account capabilities.

    The `production-app`, `platform.production-app`, and / or `platform.wallet-transfers` capabilities might appear in your list. These are read-only capabilities that Moov requests and uses for account verification purposes. These capabilities remains active with your account and require no additional action.
    """
    account_id: str
    status: CapabilityStatus
    r"""The status of the capability requested for an account."""
    created_on: datetime
    updated_on: datetime
    requirements: NotRequired[CapabilityRequirementTypedDict]
    r"""Represents individual and business data necessary to facilitate the enabling of a capability for an account."""
    disabled_reason: NotRequired[str]
    disabled_on: NotRequired[datetime]


class Capability(BaseModel):
    capability: CapabilityID
    r"""Moov account capabilities.

    The `production-app`, `platform.production-app`, and / or `platform.wallet-transfers` capabilities might appear in your list. These are read-only capabilities that Moov requests and uses for account verification purposes. These capabilities remains active with your account and require no additional action.
    """

    account_id: Annotated[str, pydantic.Field(alias="accountID")]

    status: CapabilityStatus
    r"""The status of the capability requested for an account."""

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]

    updated_on: Annotated[datetime, pydantic.Field(alias="updatedOn")]

    requirements: Optional[CapabilityRequirement] = None
    r"""Represents individual and business data necessary to facilitate the enabling of a capability for an account."""

    disabled_reason: Annotated[
        Optional[str], pydantic.Field(alias="disabledReason")
    ] = None

    disabled_on: Annotated[Optional[datetime], pydantic.Field(alias="disabledOn")] = (
        None
    )
