"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .address import Address, AddressTypedDict
from .businesstype import BusinessType
from .industrycodes import IndustryCodes, IndustryCodesTypedDict
from .phonenumber import PhoneNumber, PhoneNumberTypedDict
from .primaryregulator import PrimaryRegulator
from .representative import Representative, RepresentativeTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class BusinessProfileTypedDict(TypedDict):
    r"""Describes a business."""

    legal_business_name: str
    r"""The legal name under which the entity is registered."""
    owners_provided: bool
    doing_business_as: NotRequired[str]
    r"""A registered trade name under which the business operates, if different from its legal name."""
    business_type: NotRequired[BusinessType]
    r"""The type of entity represented by this business."""
    address: NotRequired[AddressTypedDict]
    phone: NotRequired[PhoneNumberTypedDict]
    email: NotRequired[str]
    website: NotRequired[str]
    description: NotRequired[str]
    tax_id_provided: NotRequired[bool]
    r"""Indicates whether a tax ID has been provided for this business."""
    representatives: NotRequired[List[RepresentativeTypedDict]]
    industry_codes: NotRequired[IndustryCodesTypedDict]
    primary_regulator: NotRequired[PrimaryRegulator]
    r"""If the business is a financial institution, this field describes its primary regulator."""


class BusinessProfile(BaseModel):
    r"""Describes a business."""

    legal_business_name: Annotated[str, pydantic.Field(alias="legalBusinessName")]
    r"""The legal name under which the entity is registered."""

    owners_provided: Annotated[bool, pydantic.Field(alias="ownersProvided")]

    doing_business_as: Annotated[
        Optional[str], pydantic.Field(alias="doingBusinessAs")
    ] = None
    r"""A registered trade name under which the business operates, if different from its legal name."""

    business_type: Annotated[
        Optional[BusinessType], pydantic.Field(alias="businessType")
    ] = None
    r"""The type of entity represented by this business."""

    address: Optional[Address] = None

    phone: Optional[PhoneNumber] = None

    email: Optional[str] = None

    website: Optional[str] = None

    description: Optional[str] = None

    tax_id_provided: Annotated[
        Optional[bool], pydantic.Field(alias="taxIDProvided")
    ] = None
    r"""Indicates whether a tax ID has been provided for this business."""

    representatives: Optional[List[Representative]] = None

    industry_codes: Annotated[
        Optional[IndustryCodes], pydantic.Field(alias="industryCodes")
    ] = None

    primary_regulator: Annotated[
        Optional[PrimaryRegulator], pydantic.Field(alias="primaryRegulator")
    ] = None
    r"""If the business is a financial institution, this field describes its primary regulator."""
