"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .feecategory import FeeCategory
from .feemodel import FeeModel
from .feeproperties import FeeProperties, FeePropertiesTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import Any, Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class BillableFeeTypedDict(TypedDict):
    fee_model: FeeModel
    r"""Specifies the pricing model used for the calculation of the final fee."""
    fee_category: FeeCategory
    billable_fee_id: NotRequired[str]
    billable_event: NotRequired[str]
    r"""A unique code identifying a charge."""
    fee_name: NotRequired[str]
    r"""Specifies the name of the fee that will be billed."""
    fee_properties: NotRequired[FeePropertiesTypedDict]
    r"""Defines the specific parameters used for fee calculation."""
    fee_conditions: NotRequired[Dict[str, Any]]
    r"""Defines the specific conditions that must be met for the fee to be applied."""


class BillableFee(BaseModel):
    fee_model: Annotated[FeeModel, pydantic.Field(alias="feeModel")]
    r"""Specifies the pricing model used for the calculation of the final fee."""

    fee_category: Annotated[FeeCategory, pydantic.Field(alias="feeCategory")]

    billable_fee_id: Annotated[Optional[str], pydantic.Field(alias="billableFeeID")] = (
        None
    )

    billable_event: Annotated[Optional[str], pydantic.Field(alias="billableEvent")] = (
        None
    )
    r"""A unique code identifying a charge."""

    fee_name: Annotated[Optional[str], pydantic.Field(alias="feeName")] = None
    r"""Specifies the name of the fee that will be billed."""

    fee_properties: Annotated[
        Optional[FeeProperties], pydantic.Field(alias="feeProperties")
    ] = None
    r"""Defines the specific parameters used for fee calculation."""

    fee_conditions: Annotated[
        Optional[Dict[str, Any]], pydantic.Field(alias="feeConditions")
    ] = None
    r"""Defines the specific conditions that must be met for the fee to be applied."""
