"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .achreturncode import ACHReturnCode
from .rtprejectioncode import RTPRejectionCode
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class BankAccountExceptionTypedDict(TypedDict):
    r"""Reason for, and details related to, an `errored` or `verificationFailed` bank account status."""

    description: str
    r"""Details related to an `errored` or `verificationFailed` bank account status."""
    ach_return_code: NotRequired[ACHReturnCode]
    r"""The return code of an ACH transaction that caused the bank account status to change.

    - R02: Account Closed
    - R03: No Account/Unable to Locate Account
    - R04: Invalid Account Number
    - R05: Improper Debit to Consumer Account
    - R07: Authorization Revoked by Customer
    - R08: Payment Stopped
    - R10: Customer Advises Originator is Not Known or Authorized to Receiver
    - R11: Customer Advises Entry Not in Accordance with the Terms of the Authorization
    - R12: Branch Sold to Another DFI
    - R13: RDFI not qualified to participate
    - R14: Representative payee deceased or unable to continue in that capacity
    - R15: Beneficiary or bank account holder
    - R16: Bank account frozen
    - R17: Entry with Invalid Account Number Initiated Under Questionable Circumstances
    - R20: Non-payment bank account
    - R23: Credit entry refused by receiver
    - R29: Corporate customer advises not authorized
    - R34: Limited participation RDFI
    - R38: Stop Payment on Source Document (Adjustment Entry)
    - R39: Improper Source Document
    """
    rtp_rejection_code: NotRequired[RTPRejectionCode]
    r"""The rejection code of an RTP transaction that caused the bank account status to change.

    - AC03: Account Invalid
    - AC04: Account Closed
    - AC06: Account Blocked
    - AC14: Creditor Account Type Invalid
    - AG01: Transactions Forbidden On Account
    - AG03: Transaction Type Not Supported
    - MD07: Customer Deceased
    """


class BankAccountException(BaseModel):
    r"""Reason for, and details related to, an `errored` or `verificationFailed` bank account status."""

    description: str
    r"""Details related to an `errored` or `verificationFailed` bank account status."""

    ach_return_code: Annotated[
        Optional[ACHReturnCode], pydantic.Field(alias="achReturnCode")
    ] = None
    r"""The return code of an ACH transaction that caused the bank account status to change.

    - R02: Account Closed
    - R03: No Account/Unable to Locate Account
    - R04: Invalid Account Number
    - R05: Improper Debit to Consumer Account
    - R07: Authorization Revoked by Customer
    - R08: Payment Stopped
    - R10: Customer Advises Originator is Not Known or Authorized to Receiver
    - R11: Customer Advises Entry Not in Accordance with the Terms of the Authorization
    - R12: Branch Sold to Another DFI
    - R13: RDFI not qualified to participate
    - R14: Representative payee deceased or unable to continue in that capacity
    - R15: Beneficiary or bank account holder
    - R16: Bank account frozen
    - R17: Entry with Invalid Account Number Initiated Under Questionable Circumstances
    - R20: Non-payment bank account
    - R23: Credit entry refused by receiver
    - R29: Corporate customer advises not authorized
    - R34: Limited participation RDFI
    - R38: Stop Payment on Source Document (Adjustment Entry)
    - R39: Improper Source Document
    """

    rtp_rejection_code: Annotated[
        Optional[RTPRejectionCode], pydantic.Field(alias="rtpRejectionCode")
    ] = None
    r"""The rejection code of an RTP transaction that caused the bank account status to change.

    - AC03: Account Invalid
    - AC04: Account Closed
    - AC06: Account Blocked
    - AC14: Creditor Account Type Invalid
    - AG01: Transactions Forbidden On Account
    - AG03: Transaction Type Not Supported
    - MD07: Customer Deceased
    """
