"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from moovio_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class AppleBillingContactTypedDict(TypedDict):
    r"""Billing contact information as returned from Apple Pay.

    Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymentcontact)
    for more information.
    """

    address_lines: NotRequired[List[str]]
    r"""Address lines 1 and 2 for the contact."""
    locality: NotRequired[str]
    r"""The contact's city."""
    postal_code: NotRequired[str]
    r"""The contact's postal code."""
    administrative_area: NotRequired[str]
    r"""The contact's two-letter state code."""
    country_code: NotRequired[str]
    r"""The contact's two-letter ISO 3166"""


class AppleBillingContact(BaseModel):
    r"""Billing contact information as returned from Apple Pay.

    Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymentcontact)
    for more information.
    """

    address_lines: Annotated[
        Optional[List[str]], pydantic.Field(alias="addressLines")
    ] = None
    r"""Address lines 1 and 2 for the contact."""

    locality: Optional[str] = None
    r"""The contact's city."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""The contact's postal code."""

    administrative_area: Annotated[
        Optional[str], pydantic.Field(alias="administrativeArea")
    ] = None
    r"""The contact's two-letter state code."""

    country_code: Annotated[Optional[str], pydantic.Field(alias="countryCode")] = None
    r"""The contact's two-letter ISO 3166"""
