# ubermag

[Marijan Beg](https://github.com/marijanbeg)<sup>1,2</sup>, [Martin Lang](https://github.com/lang-m)<sup>2</sup>, [Samuel Holt](https://github.com/samjrholt)<sup>2,3</sup>, [Swapneel Amit Pathak](https://github.com/swapneelap)<sup>2,4</sup>, [Ryan A. Pepper](https://github.com/rpep)<sup>5</sup>, [Thomas Kluyver](https://github.com/takluyver)<sup>6</sup>, [Jeroen Mulkers](https://github.com/JeroenMulkers)<sup>7</sup>, [Jonathan Leliaert](https://github.com/JLeliaert)<sup>7</sup>, and [Hans Fangohr](https://github.com/fangohr)<sup>2,4,8</sup>

<sup>1</sup> *Department of Earth Science and Engineering, Imperial College London, London SW7 2AZ, UK*  
<sup>2</sup> *Faculty of Engineering and Physical Sciences, University of Southampton, Southampton SO17 1BJ, UK*  
<sup>3</sup> *Department of Physics, University of Warwick, Coventry CV4 7AL, UK*  
<sup>4</sup> *Max Planck Institute for the Structure and Dynamics of Matter, Luruper Chaussee 149, 22761 Hamburg, Germany*  
<sup>5</sup> *Research Software Group, University of Birmingham, Birmingham B15 2TT, UK*  
<sup>6</sup> *European XFEL GmbH, Holzkoppel 4, 22869 Schenefeld, Germany*  
<sup>7</sup> *Faculty of Sciences, Ghent University, Krijgslaan 281, S12, 9000 Ghent, Belgium*  
<sup>8</sup> *Center for Free-Electron Laser Science, Luruper Chaussee 149, 22761 Hamburg, Germany*  


| Description | Badge |
| --- | --- |
| Tests | [![Build status](https://github.com/ubermag/ubermag/workflows/workflow/badge.svg)](https://github.com/ubermag/ubermag/actions?query=workflow%3Aworkflow) |
|       | [![conda](https://github.com/ubermag/ubermag/workflows/conda/badge.svg)](https://github.com/ubermag/ubermag/actions?query=workflow%3Aconda) |
| Linting | [![pre-commit.ci status](https://results.pre-commit.ci/badge/github/ubermag/ubermag/master.svg)](https://results.pre-commit.ci/latest/github/ubermag/ubermag/master) |
|         | [![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black) |
| Releases | [![PyPI version](https://badge.fury.io/py/ubermag.svg)](https://badge.fury.io/py/ubermag) |
|          | [![Anaconda-Server Badge](https://anaconda.org/conda-forge/ubermag/badges/version.svg)](https://anaconda.org/conda-forge/ubermag) |
| Coverage | [![codecov](https://codecov.io/gh/ubermag/ubermag/branch/master/graph/badge.svg?token=hcK4fofmrL)](https://codecov.io/gh/ubermag/ubermag) |
| Documentation | [![Documentation](https://img.shields.io/badge/Docs-ubermag.github.io-blue)](https://ubermag.github.io/documentation/ubermag.html) |
| YouTube | [![YouTube](https://img.shields.io/badge/YouTube-ubermag-blue)](https://www.youtube.com/channel/UC7MSqVQSMFV42R1jAYmKGLg) |
| Binder | [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/ubermag/ubermag/latest?urlpath=lab/tree/docs) |
| Platforms | [![Platforms](https://anaconda.org/conda-forge/ubermag/badges/platforms.svg)](https://anaconda.org/conda-forge/ubermag) |
| Downloads | [![Downloads](https://anaconda.org/conda-forge/ubermag/badges/downloads.svg)](https://anaconda.org/conda-forge/ubermag) |
| License | [![License](https://img.shields.io/badge/License-BSD%203--Clause-blue.svg)](https://opensource.org/licenses/BSD-3-Clause) |
| DOI | [![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.3539495.svg)](https://doi.org/10.5281/zenodo.3539495) |

## About

`ubermag` is a Python package, integrated with Jupyter, providing:

- Meta package for Ubermag project,

- Logging control in Ubermag packages.


It is available on Windows, MacOS, and Linux. It requires Python 3.8+.

## Documentation

APIs and tutorials are available in the documentation. To access the documentation, use the badge in the table above.

## Installation, testing, and upgrade

We recommend installation using `conda` package manager. Instructions can be found in the [documentation](https://ubermag.github.io/installation.html).

## Binder

This package can be used in the cloud via Binder. To access Binder, use the badge in the table above.

## YouTube

YouTube video tutorials are available on the [Ubermag channel](https://www.youtube.com/channel/UC7MSqVQSMFV42R1jAYmKGLg).

## Support

If you require support, have questions, want to report a bug, or want to suggest an improvement, please raise an issue in [ubermag/help](https://github.com/ubermag/help) repository.

## Contributions

All contributions are welcome, however small they are. If you would like to contribute, please fork the repository and create a pull request. If you are not sure how to contribute, please contact us by raising an issue in [ubermag/help](https://github.com/ubermag/help) repository, and we are going to help you get started and assist you on the way.

**Contributors**:


## License

Licensed under the BSD 3-Clause "New" or "Revised" License. For details, please refer to the [LICENSE](LICENSE) file.

## How to cite

1. M. Beg, M. Lang, and H. Fangohr. Ubermag: Towards more effective micromagnetic workflows. [*IEEE Transactions on Magnetics* **58**, 7300205](https://doi.org/10.1109/TMAG.2021.3078896) (2022).

2. M. Beg, R. A. Pepper, and H. Fangohr. User interfaces for computational science: A domain specific language for OOMMF embedded in Python. [*AIP Advances* **7**, 56025](http://aip.scitation.org/doi/10.1063/1.4977225) (2017).

3. Marijan Beg, Martin Lang, Samuel Holt, Swapneel Amit Pathak, Ryan A. Pepper, Thomas Kluyver, Jeroen Mulkers, Jonathan Leliaert, and Hans Fangohr. ubermag: Meta package for Ubermag project. DOI: [10.5281/zenodo.3539495](http://doi.org/10.5281/zenodo.3539495) (2022).

## Acknowledgements

- [OpenDreamKit](http://opendreamkit.org/) – Horizon 2020 European Research Infrastructure project (676541)

- EPSRC Programme Grant on [Skyrmionics](http://www.skyrmions.ac.uk) (EP/N032128/1)
