# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['hammurabi', 'hammurabi.rules']

package_data = \
{'': ['*']}

install_requires = \
['click>=7.0,<8.0',
 'configupdater>=1.0.1,<2.0.0',
 'github3.py>=1.3.0,<2.0.0',
 'gitpython>=3.0.5,<4.0.0',
 'pydantic>=1.4,<2.0',
 'pyhocon>=0.3.54,<0.4.0',
 'ruamel.yaml>=0.16.5,<0.17.0',
 'toml>=0.10.0,<0.11.0',
 'ujson>=1.35,<2.0']

entry_points = \
{'console_scripts': ['hammurabi = hammurabi.main:cli']}

setup_kwargs = {
    'name': 'hammurabi',
    'version': '0.1.1',
    'description': 'Hammurabi is an extensible CLI tool responsible for enforcing user-defined rules on a git repository.',
    'long_description': 'Hammurabi\n*********\n\n.. image:: https://img.shields.io/pypi/v/hammurabi.svg\n    :target: https://pypi.python.org/pypi/hammurabi\n    :alt: PyPi Package\n\n.. image:: https://travis-ci.org/gabor-boros/hammurabi.svg?branch=master\n    :target: https://travis-ci.org/gabor-boros/hammurabi\n    :alt: Build Status\n\n.. image:: https://readthedocs.org/projects/hammurabi/badge/?version=latest\n    :target: https://hammurabi.readthedocs.io/en/latest/?badge=latest\n    :alt: Documentation Status\n\n.. image:: https://api.codeclimate.com/v1/badges/bcebab7105dfd82f358b/maintainability\n   :target: https://codeclimate.com/github/gabor-boros/hammurabi/maintainability\n   :alt: Maintainability\n\n.. image:: https://api.codeclimate.com/v1/badges/bcebab7105dfd82f358b/test_coverage\n    :target: https://codeclimate.com/github/gabor-boros/hammurabi/test_coverage\n    :alt: Test Coverage\n\n.. image:: https://img.shields.io/badge/code%20style-black-000000.svg\n    :target: https://github.com/ambv/black\n    :alt: Black Formatted\n\n.. image:: https://bestpractices.coreinfrastructure.org/projects/3587/badge\n    :target: https://bestpractices.coreinfrastructure.org/projects/3587\n    :alt: CII Best Practices\n\n\nMass changes made easy.\n\nHammurabi is an extensible CLI tool responsible for enforcing user-defined rules\non a git repository.\n\nFeatures\n========\n\nHammurabi integrates well with both git and Github to make sure that the\nexecution happens on a separate branch and the committed changes are pushed\nto the target repository. After pushing to the target repository, a pull\nrequest will be opened.\n\nHammurabi supports several operations (Rules) by default. These Rules can do\n\n* file and directory operations like copy, move, create or delete\n* manipulation of attributes like ownership or access permissions change\n* file and directory manipulations\n* piped rule execution (output of a rule is the input of the next rule)\n* children rule execution (output of a rule is the input of the upcoming rules)\n* working with ``plain text`` and ``ini`` files\n\nUpcoming file format support:\n\n* ``yaml``\n* ``toml``\n* ``json``\n* ``hocon``\n\nInstallation\n============\n\nHammurabi can be installed by running ``pip install hammurabi`` and it requires\nPython 3.7.0+ to run. This is the preferred method to install Hammurabi, as it\nwill always install the most recent stable release. If you don\'t have `pip`_\ninstalled, this `Python installation guide`_ can guide\nyou through the process.\n\n.. _pip: https://pip.pypa.io\n.. _Python installation guide: http://docs.python-guide.org/en/latest/starting/installation/\n\nConfiguration\n=============\n\nFor configuration instructions, please visit the documentation_ site.\n\n.. _documentation: https://hammurabi.readthedocs.io/en/latest/config.html\n\nCommand line options\n====================\n\n.. code-block:: bash\n\n    hammurabi [OPTIONS] COMMAND [ARGS]...\n\n    Hammurabi is an extensible CLI tool responsible for enforcing user-defined\n    rules on a git repository.\n\n    Find more information at: https://hammurabi.readthedocs.io/latest/\n\n    Options:\n    -c, --config PATH               Set the configuration file.  [default:\n                                    pyproject.toml]\n    --target PATH                   Set target path. If target is a git repo,\n                                    commits will be created.\n    --repository TEXT               Set the remote repository. Required format:\n                                    owner/repository\n    --github-token TEXT             Set github access token\n    --log-level [DEBUG|INFO|WARNING|ERROR]\n                                    Set logging level.\n    --help                          Show this message and exit.\n\n    Commands:\n    describe  Show details of a specific resource or group of resources.\n    enforce   Execute all registered Law.\n    get       Show a specific resource or group of resources.\n    version   Print Hammurabi version.\n\nUsage examples\n==============\n\nIn every case, make sure that you clone the target repository prior using Hammurabi.\nIt will not clone the target repository.\n\nEnforce registered laws\n-----------------------\n\n.. code-block:: bash\n\n    $ hammurabi enforce\n    [INFO]  2020-14-07 16:31 - Checkout branch "hammurabi"\n    [INFO]  2020-14-07 16:31 - Executing law "L001"\n    [INFO]  2020-14-07 16:31 - Running task for "configure file exists"\n    [INFO]  2020-14-07 16:31 - Rule "configure file exists" finished successfully\n    [INFO]  2020-14-07 16:31 - Running task for "Minimum clang version is set"\n    [INFO]  2020-14-07 16:31 - Rule "Minimum clang version is set" finished successfully\n    [INFO]  2020-14-07 16:31 - Running task for "Minimum icc version is set"\n    [INFO]  2020-14-07 16:31 - Rule "Minimum icc version is set" finished successfully\n    [INFO]  2020-14-07 16:31 - Running task for "Minimum lessc version is set"\n    [INFO]  2020-14-07 16:31 - Rule "Minimum lessc version is set" finished successfully\n    [INFO]  2020-14-07 16:31 - Running task for "Maximum lessc version is set"\n    [INFO]  2020-14-07 16:31 - Rule "Maximum lessc version is set" finished successfully\n    [INFO]  2020-14-07 16:31 - Pushing changes\n    [INFO]  2020-14-07 16:35 - Checking for opened pull request\n    [INFO]  2020-14-07 16:35 - Opening pull request\n\nListing available laws\n----------------------\n\n.. code-block:: bash\n\n    $ hammurabi get laws\n    - Gunicorn config set up properly\n\nGet info about a law by its name\n--------------------------------\n\n.. code-block:: bash\n\n    $ hammurabi get law "Gunicorn config set up properly"\n    Gunicorn config set up properly\n\n    Change the gunicorn configuration based on our learnings\n    described at: https://google.com/?q=gunicorn.\n\n    If the gunicorn configuration does not exist, create a\n    new one configuration file.\n\nGet all registered (root) rules\n-------------------------------\n\n.. code-block:: bash\n\n    $ hammurabi get rules\n    - Rule 1\n    - Rule 5\n\nGet a rule by its name\n----------------------\n\n.. code-block:: bash\n\n    $ hammurabi get rule "Rule 1"\n    Rule 1\n\n    Ensure that a file exists. If the file does not exists,\n    this :class:`hammurabi.rules.base.Rule` will create it.\n\n    Due to the file is already created by :func:`pre_task_hook`\n    there is no need to do anything just return the input parameter.\n\nDescribe a law by its name\n--------------------------\n\n.. code-block:: bash\n\n    $ hammurabi describe law "Gunicorn config set up properly"\n    Gunicorn config set up properly\n\n    Change the gunicorn configuration based on our learnings\n    described at: http://docs.gunicorn.org/en/latest/configure.html.\n\n    If the gunicorn configuration does not exist, create a\n    new one configuration file.\n\n    Rules:\n    --> Rule 1\n    --> Rule 2\n    --> Rule 3\n    --> Rule 4\n    --> Rule 5\n\nDescribe a rule by its name\n---------------------------\n\n.. code-block:: bash\n\n    $ hammurabi describe rule "Rule 1"\n    Rule 1\n\n    Ensure that a file exists. If the file does not exists,\n    this :class:`hammurabi.rules.base.Rule` will create it.\n\n    Due to the file is already created by :func:`pre_task_hook`\n    there is no need to do anything just return the input parameter.\n\n    Chain:\n    --> Rule 1\n    --> Rule 2\n    --> Rule 3\n    --> Rule 4\n\nGetting the execution order of laws and rules\n---------------------------------------------\n\n.. code-block:: bash\n\n    $ hammurabi get order\n    - Gunicorn config set up properly\n    --> Rule 1\n    --> Rule 2\n    --> Rule 3\n    --> Rule 4\n    --> Rule 5\n\nCustom Rules\n============\n\nAlthough the project aims to support as many general operations as it can,\nthe need for adding custom rules may arise.\n\nTo extend Hammurabi with custom rules, you will need to inherit a class\nfrom ``Rule`` and define its abstract methods.\n\nThe following example will show you how to create and use a custom rule.\nFor more reference please check how the existing rules are implemented.\n\n.. code-block:: python\n\n    # custom.py\n    import shutil\n    import logging\n    from hammurabi.mixins import GitMixin\n    from hammurabi.rules.base import Rule\n\n\n    class CustomOwnerChanged(Rule, GitMixin):\n        """\n        Change the ownership of a file or directory to <original user>:admin.\n        """\n\n        def __init__(self, name: str, path: Optional[Path] = None, **kwargs):\n            super().__init__(name, path, **kwargs)\n\n        def post_task_hook(self):\n            self.git_add(self.param)\n\n        def task(self) -> Path:\n            # Since ``Rule`` is setting its 2nd parameter to ``self.param``,\n            # we can use ``self.param`` to access the target file\'s path.\n            logging.debug(\'Changing group of "%s" to admin\', str(self.param))\n            shutil.chown(self.param, group="admin")\n            return self.param\n\nContributing\n============\n\nHurray, You reached this section, which means you are ready\nto contribute.\n\nPlease read our contibuting guideline_. This guideline will\nwalk you through how can you successfully contribute to\nHammurabi.\n\n.. _guideline: https://github.com/gabor-boros/hammurabi/blob/master/CONTRIBUTING.rst\n\nInstallation\n------------\n\nFor development you will need poetry_. After poetry installed,\nsimply run `poetry install`. This command will both create the\nvirtualenv and install development dependencies for you.\n\n.. _poetry: https://python-poetry.org/docs/#installation\n\n\nUseful make Commands\n--------------------\n\n+------------------+-------------------------------------+\n| Command          | Description                         |\n+==================+=====================================+\n| help             | Print available make commands       |\n+------------------+-------------------------------------+\n| clean            | Remove all artifacts                |\n+------------------+-------------------------------------+\n| clean-build      | Remove build artifacts              |\n+------------------+-------------------------------------+\n| clean-mypy       | Remove mypy artifacts               |\n+------------------+-------------------------------------+\n| clean-pyc        | Remove Python artifacts             |\n+------------------+-------------------------------------+\n| clean-test       | Remove test artifacts               |\n+------------------+-------------------------------------+\n| doc              | Genereate Sphinx documentation      |\n+------------------+-------------------------------------+\n| format           | Run several formatters              |\n+------------------+-------------------------------------+\n| lint             | Run several linters after format    |\n+------------------+-------------------------------------+\n| test             | Run all tests with coverage         |\n+------------------+-------------------------------------+\n| test-unit        | Run unit tests with coverage        |\n+------------------+-------------------------------------+\n| test-integration | Run integration tests with coverage |\n+------------------+-------------------------------------+\n\nWhy Hammurabi?\n==============\n\nHammurabi was the sixth king in the Babylonian dynasty,\nwhich ruled in central Mesopotamia from c. 1894 to 1595 B.C.\n\nThe Code of Hammurabi was one of the earliest and most\ncomplete written legal codes and was proclaimed by the\nBabylonian king Hammurabi, who reigned from 1792 to 1750 B.C.\nHammurabi expanded the city-state of Babylon along the Euphrates\nRiver to unite all of southern Mesopotamia. The Hammurabi code\nof laws, a collection of 282 rules, established standards for\ncommercial interactions and set fines and punishments to meet\nthe requirements of justice. Hammurabi’s Code was carved onto\na massive, finger-shaped black stone stele (pillar) that was\nlooted by invaders and finally rediscovered in 1901.\n',
    'author': 'Gábor Boros',
    'author_email': 'gabor.brs@gmail.com',
    'maintainer': 'Gábor Boros',
    'maintainer_email': 'gabor.brs@gmail.com',
    'url': 'https://github.com/gabor-boros/hammurabi/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
