import pytest

from examples.index import (
    vdom,
    render,
    split,
    scope,
    props,
    escaping,
    prevent_escaping,
    expressions,
    conditional,
    looping,
    components,
    callable,
    context,
)
from examples.usage import (
    static_string,
    static_stringLiteral,
    static_stringB,
    static_stringC,
    static_stringC2,
    static_stringD,
    static_stringE,
    static_stringDoctype,
    variables,
    variablesA,
    variablesB,
    variablesC,
    variablesD,
    expressions as usage_expressions,
    expressionsA,
    expressionsB,
    conditional as usage_conditional,
    looping as usage_looping,
    loopingA,
    components as usage_components,
    components_vdom,
    componentsA,
    componentsB,
    componentsC,
    componentsD,
    componentsE,
    componentsPassComponent,
    componentsPassComponentB,
    componentsPassComponentC,
    componentsF,
    componentsG,
    componentsH,
    componentsI,
    componentsJ,
    context as usage_context,
    contextA,
    spread,
)


@pytest.mark.parametrize(
    'target',
    [
        vdom,
        render,
        split,
        scope,
        props,
        expressions,
        escaping,
        prevent_escaping,
        expressions,
        conditional,
        looping,
        components,
        callable,
        context,
        static_string,
        static_stringLiteral,
        static_stringB,
        static_stringC,
        static_stringC2,
        static_stringD,
        static_stringE,
        static_stringDoctype,
        variables,
        variablesA,
        variablesB,
        variablesC,
        variablesD,
        usage_expressions,
        expressionsA,
        expressionsB,
        usage_conditional,
        usage_looping,
        loopingA,
        usage_components,
        components_vdom,
        componentsA,
        componentsB,
        componentsC,
        componentsD,
        componentsE,
        componentsPassComponent,
        componentsPassComponentB,
        componentsPassComponentC,
        componentsF,
        componentsG,
        componentsH,
        componentsI,
        componentsJ,
        usage_context,
        contextA,
        spread,
    ],
)
def test_examples(target):
    expected, actual = target.test()
    assert expected == actual
