# What Is It

In web development, modern frontends have a different model for views and templating than Python.
Architecturally, they use "Virtual DOMs" (VDOMs) which then update the real DOM.

To the programmer, many of them adopt a component-oriented model with lots of tiny pieces, "single responsibility principle", isolation, reuse, and rich ways of getting data into the component for rendering.
Equally, rather than treat templating as separate from programming, they mix "templating" together with programming.
For example, JSX has as its point to make templating feel more like JavaScript development.

JSX is very popular but has some drawbacks in its tooling impact.
With the rise of JavaScript [template literals](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Template_literals) and more specifically tagged templates, there is an effort at lighter-weight templating that is even more language-native.

[`htm`](https://github.com/developit/htm) has become the exemplar of this approach.
As the docs say: "htm is JSX-like syntax in plain JavaScript - no transpiler necessary."

[Joachim Viide](https://github.com/jviide), a contributor to `htm`, has created to packages that help deliver this for Python:

1. [`tagged`](https://github.com/jviide/tagged) provides tagged literals.
Python introduced f-strings which give template literals, but doesn't have a way to prefix with a function.
`tagged` provides a similar development experience as JavaScript tagged templates.

2. [`htm.py`](https://github.com/jviide/htm.py) provides a Python "port" of the `htm` package.
It takes a tagged template and produces a VDOM.
That is, a nested Python datastructure representing the result of evaluating a tagged template.

These give two of the three pieces needed. `viewdom` gives the third: rendering.

## Rendering

We need a way to serialize a VDOM to a string.
Along the way, we need a way to evaluate components and subcomponents, getting them to generate a VDOM, and serializing them to a string.

In JavaScript, this part is done by machinery in the toolchain.
It's also tied to DOM diffing and patching, to very quickly re-render just the parts that change.
In Python, we are mostly (though not completely) interested in generating a string on the server and sending it to the browser (or writing to disk.)

`viewdom` is a Python package for taking a VDOM generated by something such as `htm.py` and serializing to a string.
Along the way, it has a number of intermediate steps that allow for some innovative thinking, such as replicating the React context and hook ideas to easily get state to deeply-nested components.
