import React, { useState } from 'react';
import { createUseStyles } from 'react-jss';
import { useStoreState } from 'pullstate';
import { UIStore } from '../stores/UIStore';
import { MenuBar } from '../components/MenuBar';
import { Explore } from '../tabs/Explore';
import { Notebook } from '../tabs/Notebook';
import { Settings } from '../tabs/Settings';
const useStyles = createUseStyles({
    container: {
        flex: 1,
        display: 'flex',
        flexDirection: 'column',
        overflow: 'auto'
    },
    menuBar: {
        marginTop: '16px'
    },
    content: {
        flex: 1,
        overflow: 'auto',
        '& > div': {
            height: '100%'
        }
    },
    instanceOption: {
        lineHeight: 0
    },
    infoIcon: {
        fontSize: '15px'
    },
    hidden: {
        display: 'none'
    }
});
export const MainPanel = props => {
    const classes = useStyles();
    const activeInstance = useStoreState(UIStore, s => s.activeInstance);
    const [activeMenu, setActiveMenu] = useState(activeInstance ? 1 : 3);
    const menus = [
        { title: 'Explore', value: 1, right: false, disabled: !activeInstance },
        { title: 'Notebook', value: 2, right: false, disabled: !activeInstance },
        {
            title: (React.createElement("div", { className: classes.instanceOption },
                React.createElement("i", { className: `${classes.infoIcon} material-icons` }, "info"))),
            value: 3,
            right: true
        }
    ];
    return (React.createElement("div", Object.assign({ className: classes.container }, props),
        React.createElement("div", { className: classes.menuBar },
            React.createElement(MenuBar, { menus: menus, value: activeMenu, onChange: setActiveMenu })),
        React.createElement("div", { className: classes.content },
            React.createElement("div", { className: activeMenu !== 1 ? classes.hidden : '' }, activeInstance && React.createElement(Explore, null)),
            React.createElement("div", { className: activeMenu !== 2 ? classes.hidden : '' }, activeInstance && React.createElement(Notebook, null)),
            React.createElement("div", { className: activeMenu !== 3 ? classes.hidden : '' },
                React.createElement(Settings, null)))));
};
