import React from 'react';
import { createUseStyles } from 'react-jss';
const useStyles = createUseStyles({
    tab: {
        borderBottom: '1px solid var(--jp-border-color2)',
        listStyleType: 'none',
        margin: 0,
        padding: '0 8px 0 8px',
        overflow: 'hidden'
    },
    tabItem: {
        float: 'left',
        display: 'block',
        padding: '8px 12px 8px 12px',
        textTransform: 'uppercase',
        borderRadius: '4px 4px 0 0',
        fontSize: '9pt',
        cursor: 'pointer',
        '&:hover': {
            background: 'var(--jp-layout-color2)'
        },
        '&.active': {
            background: 'var(--jp-layout-color2)',
            fontWeight: 'bold'
        },
        '&.disabled': {
            opacity: 0.5,
            cursor: 'inherit',
            '&:hover': {
                background: 'none'
            },
            '&.active': {
                background: 'none'
            }
        }
    },
    tabItemRight: {
        extend: 'tabItem',
        float: 'right'
    }
});
export const MenuBar = ({ menus, value, onChange }) => {
    const classes = useStyles();
    return (React.createElement("div", null,
        React.createElement("ul", { className: classes.tab }, menus.map(menu => {
            const activeClass = menu.value === value ? 'active' : '';
            const disabledClass = menu.disabled ? 'disabled' : '';
            const tabClass = menu.right ? classes.tabItemRight : classes.tabItem;
            return (React.createElement("li", { onClick: !menu.disabled ? () => onChange(menu.value) : undefined, key: menu.value, className: `${tabClass} ${activeClass} ${disabledClass}` }, menu.title));
        }))));
};
