import React from 'react';
import { createUseStyles } from 'react-jss';
import { TextField } from '../TextField';
import { Spinning } from '../Spinning';
import { FilePickerPopover } from './FilePickerPopover';
const useStyles = createUseStyles({
    container: {
        padding: '8px 16px 8px 16px'
    },
    label: {
        margin: '4px 0 4px 0'
    },
    textFieldContainer: {
        margin: '8px 0 8px 0'
    },
    warning: {
        margin: '8px 8px 16px 8px',
        color: 'var(--jp-ui-font-color2)',
        fontSize: '9pt'
    },
    icon: {
        fontSize: '10pt',
        verticalAlign: 'middle'
    },
    iconContainer: {
        padding: '0 8px 0 0',
        display: 'flex',
        alignItems: 'center'
    },
    action: {
        cursor: 'pointer',
        color: 'var(--jp-rucio-primary-blue-color)'
    }
});
export const X509Auth = ({ params = { certificate: '', key: '', account: '' }, loading, onAuthParamsChange }) => {
    const classes = useStyles();
    const onCertPathChange = (path) => {
        onAuthParamsChange(Object.assign(Object.assign({}, params), { certificate: path }));
    };
    const onKeyPathChange = (path) => {
        onAuthParamsChange(Object.assign(Object.assign({}, params), { key: path }));
    };
    const onAccountChange = (account) => {
        onAuthParamsChange(Object.assign(Object.assign({}, params), { account }));
    };
    const loadingSpinner = (React.createElement("div", { className: classes.iconContainer },
        React.createElement(Spinning, { className: `${classes.icon} material-icons` }, "hourglass_top")));
    return (React.createElement(React.Fragment, null,
        React.createElement("div", { className: classes.container },
            React.createElement("div", { className: classes.textFieldContainer },
                React.createElement("div", { className: classes.label }, "Certificate file path"),
                React.createElement(TextField, { placeholder: "Path to certificate file", value: params.certificate, onChange: e => onCertPathChange(e.target.value), disabled: loading, after: loading ? loadingSpinner : React.createElement(SelectFileButtonTrailer, { onFilePicked: path => onCertPathChange(path) }) })),
            React.createElement("div", { className: classes.textFieldContainer },
                React.createElement("div", { className: classes.label }, "Key file path"),
                React.createElement(TextField, { placeholder: "Path to key file", value: params.key, onChange: e => onKeyPathChange(e.target.value), disabled: loading, after: loading ? loadingSpinner : React.createElement(SelectFileButtonTrailer, { onFilePicked: path => onKeyPathChange(path) }) })),
            React.createElement("div", { className: classes.warning }, "Enter the private key path if the certificate file does not include it. Passphrase-protected certificate is not supported."),
            React.createElement("div", { className: classes.textFieldContainer },
                React.createElement("div", { className: classes.label }, "Account"),
                React.createElement(TextField, { placeholder: "Account", value: params.account, onChange: e => onAccountChange(e.target.value), disabled: loading, after: loading ? loadingSpinner : undefined })))));
};
const SelectFileButtonTrailer = ({ onFilePicked }) => {
    const classes = useStyles();
    return (React.createElement("div", { className: classes.iconContainer },
        React.createElement(FilePickerPopover, { onFilePicked: onFilePicked },
            React.createElement("span", { className: `${classes.icon} ${classes.action} material-icons` }, "folder"))));
};
